from .common import *
from fan.accounts.create import get_or_create_account
from fan.accounts.set import set_account_from_logins, grant_account_access
from fan_ui.api.serializers.account import AccountSerializerV1
from fan_ui.api.query_params import pass_user_id_param, pass_org_id_param
from fan_ui.api.endpoints_v1.permissions import OrgAdminPermission


class AccountEndpoint(Endpoint):
    permission_classes = (IsAuthenticated, ApiV1TvmServicePermission, OrgAdminPermission)

    @method_decorator(pass_user_id_param)
    @method_decorator(pass_org_id_param)
    def put(self, request, user_id, org_id):
        name = self._make_account_name(org_id)
        account = get_or_create_account(name, org_id)
        grant_account_access(account, [user_id])
        set_account_from_logins(account)
        return make_ok_response(account, AccountSerializerV1)

    def _make_account_name(self, org_id):
        return "org{}".format(org_id)
