from .common import *
from fan.accounts.get import get_accounts_by_user_id
from fan_ui.api.serializers.account import AccountSerializerV1
from fan_ui.api.query_params import pass_user_id_param


class AccountListEndpoint(Endpoint):
    permission_classes = (IsAuthenticated, ApiV1TvmServicePermission)

    @method_decorator(pass_user_id_param)
    def get(self, request, user_id):
        accounts = get_accounts_by_user_id(user_id)
        return make_ok_response(accounts, AccountSerializerV1)
