from django.http import HttpResponse

from .common import *
from fan.message.render import render_preview_html
from fan_ui.api.exceptions import ResourceDoesNotExist
from fan_ui.api.query_params import (
    pass_user_id_param,
    pass_account_object,
    pass_campaign_object,
)


class CampaignHTMLPreviewEndpoint(Endpoint):
    permission_classes = (UserPermission, IsAuthenticated, ApiV1TvmServicePermission)

    @method_decorator(pass_user_id_param)
    @method_decorator(pass_account_object)
    @method_decorator(pass_campaign_object)
    def get(self, request, user_id, account, campaign):
        letter = campaign.default_letter
        if 0 == len(letter.html_body):
            raise ResourceDoesNotExist({"letter": "empty"})
        html = render_preview_html(campaign)
        return HttpResponse(html)
