from .common import *
from fan.campaigns.list import get_campaigns
from fan_ui.api.serializers.campaign import CampaignSerializerV1
from fan_ui.api.query_params import pass_user_id_param, pass_account_object, pass_states_param


class CampaignListEndpoint(Endpoint):
    permission_classes = (UserPermission, IsAuthenticated, ApiV1TvmServicePermission)

    @method_decorator(pass_user_id_param)
    @method_decorator(pass_account_object)
    @method_decorator(pass_states_param(required=False))
    def get(self, request, user_id, account, states):
        campaigns = get_campaigns(account.id, states)
        return make_ok_response(campaigns, CampaignSerializerV1)
