from django.utils.decorators import method_decorator
from django.db.models.query import QuerySet
from rest_framework import status
from rest_framework.response import Response
from fan_ui.api.bases.endpoint import Endpoint
from fan_ui.api.permissions import IsAuthenticated
from .permissions import UserPermission, ApiV1TvmServicePermission


def make_ok_response(value, Serializer):
    serializer = Serializer(value, many=isinstance(value, (list, tuple, QuerySet)))
    return Response(serializer.data, status=status.HTTP_200_OK)
