from .common import *
from django.http import HttpResponse
from fan_ui.api.query_params import pass_user_id_param, pass_account_object, pass_maillist_object
from fan.lists.maillist import retrieve_maillist_data


class MaillistDataEndpoint(Endpoint):
    permission_classes = (UserPermission, IsAuthenticated, ApiV1TvmServicePermission)

    @method_decorator(pass_user_id_param)
    @method_decorator(pass_account_object)
    @method_decorator(pass_maillist_object)
    def get(self, request, user_id, account, maillist):
        maillist_data = retrieve_maillist_data(maillist)
        return HttpResponse(maillist_data)
