from .common import *
from fan_ui.api.query_params import pass_user_id_param, pass_account_object
from fan_ui.api.serializers.maillist import MaillistSerializer
from fan.lists.maillist import get_maillists


class MaillistListEndpoint(Endpoint):
    permission_classes = (UserPermission, IsAuthenticated, ApiV1TvmServicePermission)

    @method_decorator(pass_user_id_param)
    @method_decorator(pass_account_object)
    def get(self, request, user_id, account):
        maillists = get_maillists(account)
        return make_ok_response(maillists, MaillistSerializer)
