from .common import *
from fan.accounts.get import get_accounts_by_org_id
from fan_ui.api.bases.endpoint import Endpoint
from fan_ui.api.query_params import (
    pass_user_id_param,
    pass_org_id_param,
)
from fan_ui.api.serializers.account import AccountSerializerV1
from fan_ui.api.endpoints_v1.permissions import OrgAdminPermission


class OrgAccountListEndpoint(Endpoint):
    permission_classes = (IsAuthenticated, ApiV1TvmServicePermission, OrgAdminPermission)

    @method_decorator(pass_user_id_param)
    @method_decorator(pass_org_id_param)
    def get(self, request, user_id, org_id):
        accounts = get_accounts_by_org_id(org_id)
        return make_ok_response(accounts, AccountSerializerV1)
