from .common import *
from django.http import JsonResponse
from fan.accounts.organizations.domains import get_organization_domains
from fan.utils.permissions import any_permission
from fan_ui.api.query_params import (
    pass_user_id_param,
    pass_org_id_param,
)
from fan_ui.api.endpoints_v1.permissions import OrgAccountUserPermission, OrgAdminPermission


class OrgDomainListEndpoint(Endpoint):
    permission_classes = (
        IsAuthenticated,
        ApiV1TvmServicePermission,
        any_permission(
            OrgAccountUserPermission, OrgAdminPermission, default_message="forbidden_user"
        ),
    )

    @method_decorator(pass_user_id_param)
    @method_decorator(pass_org_id_param)
    def get(self, request, user_id, org_id):
        return JsonResponse(get_organization_domains(org_id), safe=False)
