from .common import *
from django.http import JsonResponse
from fan.accounts.organizations.limits import (
    get_emails_sent_count_for_month,
    get_emails_scheduled_count,
    get_send_emails_limit,
    get_upgradable,
    get_maillists_count,
)
from fan.campaigns.get import get_draft_campaigns_count
from fan.accounts.organizations.settings import draft_campaigns_limit, maillists_limit
from fan.utils.permissions import any_permission
from fan_ui.api.query_params import (
    pass_user_id_param,
    pass_org_id_param,
)
from fan_ui.api.endpoints_v1.permissions import OrgAccountUserPermission, OrgAdminPermission


class OrgLimitsEndpoint(Endpoint):
    permission_classes = (
        IsAuthenticated,
        ApiV1TvmServicePermission,
        any_permission(
            OrgAccountUserPermission, OrgAdminPermission, default_message="forbidden_user"
        ),
    )

    @method_decorator(pass_user_id_param)
    @method_decorator(pass_org_id_param)
    def get(self, request, user_id, org_id):
        return JsonResponse(
            {
                "emails_sent": get_emails_sent_count_for_month(org_id),
                "emails_scheduled": get_emails_scheduled_count(org_id),
                "send_emails_limit": get_send_emails_limit(org_id),
                "upgradable": get_upgradable(org_id),
                "draft_campaigns_count": get_draft_campaigns_count(org_id),
                "draft_campaigns_limit": draft_campaigns_limit(org_id),
                "maillists_count": get_maillists_count(org_id),
                "maillists_limit": maillists_limit(org_id),
            }
        )
