from django.conf import settings
from django.utils.decorators import method_decorator
from rest_framework import permissions
from fan.accounts.get import user_has_role_in_account
from fan.accounts.organizations.users import is_admin, user_has_role_in_org_accounts
from fan_ui.api.permissions import TvmServicePermission
from fan_ui.api.query_params import pass_user_id_param, pass_account_object, pass_org_id_param


class UserPermission(permissions.BasePermission):
    message = "forbidden_user"

    @method_decorator(pass_user_id_param)
    @method_decorator(pass_account_object)
    def has_permission(self, request, view, user_id, account):
        return user_has_role_in_account(user_id, account)


class OrgAdminPermission(permissions.BasePermission):
    message = "not_admin"

    @method_decorator(pass_user_id_param)
    @method_decorator(pass_org_id_param)
    def has_permission(self, request, view, user_id, org_id):
        return is_admin(user_id, org_id)


class AccountAdminPermission(permissions.BasePermission):
    message = "not_admin"

    @method_decorator(pass_user_id_param)
    @method_decorator(pass_account_object)
    def has_permission(self, request, view, user_id, account):
        return is_admin(user_id, account.org_id)


class OrgAccountUserPermission(permissions.BasePermission):
    message = "forbidden_user"

    @method_decorator(pass_user_id_param)
    @method_decorator(pass_org_id_param)
    def has_permission(self, request, view, user_id, org_id):
        return user_has_role_in_org_accounts(user_id, org_id)


class ApiV1TvmServicePermission(TvmServicePermission):
    def allowed_source_ids(self):
        return settings.API_V1_TVM_ALLOWED_SOURCE_IDS
