from rest_framework.parsers import FileUploadParser as DRFFileUploadParser
from .exceptions import ValidationError


class FileUploadParser(DRFFileUploadParser):
    def get_filename(self, stream, media_type, parser_context):
        query_params = parser_context["request"].query_params
        filename = query_params.get("filename", None)
        if filename is None:
            raise ValidationError({"filename": "not_found"})
        if len(filename) == 0:
            raise ValidationError({"filename": "empty"})
        return filename
