from django.conf import settings
from rest_framework import permissions
from fan.utils.network import is_loopback_request
from fan_ui.api.authentication import TvmServiceAnonymousUser


class IsAuthenticated(permissions.IsAuthenticated):
    def has_permission(self, request, view):
        if not settings.REQUIRE_AUTH_ON_LOOPBACK and is_loopback_request(request):
            return True
        return super().has_permission(request, view)


class TvmServicePermission(permissions.BasePermission):
    message = "forbidden_service"

    def allowed_source_ids(self):
        return []

    def has_permission(self, request, view):
        user = request.user
        if user is not None and isinstance(user, TvmServiceAnonymousUser):
            source_id = request.user.source_id
            return source_id in self.allowed_source_ids()
        return True
