import rest_framework.serializers as rf_serializers

from fan.message.get import get_message_by_letter
from fan.models import Campaign


class CampaignSerializerV1(rf_serializers.ModelSerializer):
    class Meta:
        model = Campaign
        fields = (
            "created_at",
            "created_by",
            "from_email",
            "from_name",
            "modified_at",
            "slug",
            "state",
            "subject",
            "title",
        )


class CampaignDetailedSerializerV1(rf_serializers.ModelSerializer):
    letter_user_template_variables = rf_serializers.SerializerMethodField()

    class Meta:
        model = Campaign
        fields = (
            "created_at",
            "created_by",
            "from_email",
            "from_name",
            "modified_at",
            "slug",
            "state",
            "subject",
            "title",
            "letter_uploaded",
            "letter_description",
            "letter_user_template_variables",
            "maillist_uploaded",
            "maillist_description",
            "maillist_preview",
            "maillist_slug",
            "maillist_title",
            "maillist_size",
            "maillist_created_at",
            "maillist_modified_at",
            "stats",
        )

    def get_letter_user_template_variables(self, campaign):
        message = get_message_by_letter(campaign.default_letter)
        letter_user_template_variables = message.user_template_variables
        return letter_user_template_variables


class PendingCampaignSerializerV1(rf_serializers.ModelSerializer):
    account_slug = rf_serializers.CharField(source="account.name")
    campaign_slug = rf_serializers.CharField(source="slug")

    class Meta:
        model = Campaign
        fields = (
            "id",
            "account_slug",
            "campaign_slug",
            "from_email",
        )
