import rest_framework.serializers as rf_serializers

from fan.message.get import get_message_by_letter
from fan.models import Letter


class LetterSummarySerializerV1(rf_serializers.ModelSerializer):
    user_template_variables = rf_serializers.SerializerMethodField()

    class Meta:
        model = Letter
        fields = (
            "uploaded",
            "description",
            "user_template_variables",
        )

    def get_user_template_variables(self, letter):
        message = get_message_by_letter(letter)
        user_template_variables = message.user_template_variables
        return user_template_variables
