import rest_framework.serializers as rf_serializers

from fan.models import Maillist, SingleUseMailList


class MaillistSerializer(rf_serializers.ModelSerializer):
    class Meta:
        model = Maillist
        fields = ("slug", "title", "filename", "size", "created_at", "modified_at")


class DetailedMaillistSerializer(rf_serializers.ModelSerializer):
    class Meta:
        model = Maillist
        fields = (
            "slug",
            "title",
            "filename",
            "size",
            "preview",
            "created_at",
            "modified_at",
        )


class SingleUseMailListSummarySerializerV1(rf_serializers.ModelSerializer):
    uploaded = rf_serializers.SerializerMethodField()
    preview = rf_serializers.SerializerMethodField()

    class Meta:
        model = SingleUseMailList
        fields = (
            "uploaded",
            "description",
            "preview",
        )

    def get_uploaded(self, maillist):
        return maillist != None

    def get_preview(self, maillist):
        return maillist.data_preview
