from django.conf.urls import url

from fan_ui.api.endpoints_organization.index import IndexEndpoint
from fan_ui.api.endpoints_organization.limit import LimitEndpoint
from fan_ui.api.endpoints_organization.trusty import TrustyEndpoint
from fan_ui.api.endpoints_organization.catchall import CatchallEndpoint


urlpatterns = [
    url(r"^$", IndexEndpoint.as_view(), name="fan-api-organization-index"),
    url(r"^limit$", LimitEndpoint.as_view(), name="fan-api-organization-limit"),
    url(r"^trusty$", TrustyEndpoint.as_view(), name="fan-api-organization-trusty"),
    url(r"^", CatchallEndpoint.as_view(), name="fan-api-organization-catchall"),
]
