from django.conf.urls import url

from fan_ui.api.endpoints_send.catchall import CatchallEndpoint
from fan_ui.api.endpoints_send.index import IndexEndpoint
from fan_ui.api.endpoints_send.test_task_list import TestSendTaskListEndpoint
from fan_ui.api.endpoints_send.test_task_eml import TestSendTaskEMLEndpoint
from fan_ui.api.endpoints_send.campaign_eml_template import CampaignEMLTemplateEndpoint
from fan_ui.api.endpoints_send.test_task import TestSendTaskEndpoint
from fan_ui.api.endpoints_send.campaign_recipient_list import CampaignRecipientListEndpoint
from fan_ui.api.endpoints_send.campaign_unsubscribe_list import CampaignUnsubscribeListEndpoint
from fan_ui.api.endpoints_send.campaign_template_params import CampaignTemplateParamsEndpoint
from fan_ui.api.endpoints_send.pending_campaign_list import PendingCampaignListEndpoint
from fan_ui.api.endpoints_send.campaign_state import CampaignStateEndpoint


urlpatterns = [
    url(r"^$", IndexEndpoint.as_view(), name="fan-api-send-index"),
    url(
        r"^test-task-list$", TestSendTaskListEndpoint.as_view(), name="fan-api-send-test-task-list"
    ),
    url(r"^test-task$", TestSendTaskEndpoint.as_view(), name="fan-api-send-test-task"),
    url(r"^test-task-eml$", TestSendTaskEMLEndpoint.as_view(), name="fan-api-send-test-task-eml"),
    url(
        r"^campaign-eml-template$",
        CampaignEMLTemplateEndpoint.as_view(),
        name="fan-api-send-campaign-eml-template",
    ),
    url(
        r"^pending-campaign-list$",
        PendingCampaignListEndpoint.as_view(),
        name="fan-api-send-pending-campaign-list",
    ),
    url(
        r"^campaign-recipient-list$",
        CampaignRecipientListEndpoint.as_view(),
        name="fan-api-send-campaign-recipient-list",
    ),
    url(
        r"^campaign-unsubscribe-list$",
        CampaignUnsubscribeListEndpoint.as_view(),
        name="fan-api-send-campaign-unsubscribe-list",
    ),
    url(
        r"^campaign-template-params$",
        CampaignTemplateParamsEndpoint.as_view(),
        name="fan-api-send-campaign-template-params",
    ),
    url(r"^campaign-state$", CampaignStateEndpoint.as_view(), name="fan-api-send-campaign-state"),
    url(r"^", CatchallEndpoint.as_view(), name="fan-api-send-catchall"),
]
