from django.conf.urls import url

from fan_ui.api.endpoints_v1.catchall import CatchallEndpoint
from fan_ui.api.endpoints_v1.index import IndexEndpoint
from fan_ui.api.endpoints_v1.account_list import AccountListEndpoint
from fan_ui.api.endpoints_v1.account import AccountEndpoint
from fan_ui.api.endpoints_v1.account_from_logins import AccountFromLoginsEndpoint
from fan_ui.api.endpoints_v1.account_user_list import AccountUserListEndpoint
from fan_ui.api.endpoints_v1.campaign_details import CampaignDetailsEndpoint
from fan_ui.api.endpoints_v1.campaign_list import CampaignListEndpoint
from fan_ui.api.endpoints_v1.campaign import CampaignEndpoint
from fan_ui.api.endpoints_v1.campaign_maillist import CampaignMailListEndpoint
from fan_ui.api.endpoints_v1.maillist_data import MaillistDataEndpoint
from fan_ui.api.endpoints_v1.maillist_list import MaillistListEndpoint
from fan_ui.api.endpoints_v1.maillist import MaillistEndpoint
from fan_ui.api.endpoints_v1.org_account_list import OrgAccountListEndpoint
from fan_ui.api.endpoints_v1.org_domain_list import OrgDomainListEndpoint
from fan_ui.api.endpoints_v1.org_limits import OrgLimitsEndpoint
from fan_ui.api.endpoints_v1.test_send_task import TestSendTaskEndpoint
from fan_ui.api.endpoints_v1.campaign_letter import CampaignLetterEndpoint
from fan_ui.api.endpoints_v1.campaign_html_preview import CampaignHTMLPreviewEndpoint
from fan_ui.api.endpoints_v1.campaign_state import CampaignStateEndpoint


urlpatterns = [
    url(r"^$", IndexEndpoint.as_view(), name="fan-api-index"),
    url(r"^account-list$", AccountListEndpoint.as_view(), name="fan-api-account-list"),
    url(r"^account$", AccountEndpoint.as_view(), name="fan-api-account"),
    url(
        r"^account-from-logins$",
        AccountFromLoginsEndpoint.as_view(),
        name="fan-api-account-from-logins",
    ),
    url(
        r"^account-user-list$", AccountUserListEndpoint.as_view(), name="fan-api-account-user-list"
    ),
    url(r"^maillist-data$", MaillistDataEndpoint.as_view(), name="fan-api-maillist-data"),
    url(r"^maillist-list$", MaillistListEndpoint.as_view(), name="fan-api-maillist-list"),
    url(r"^maillist$", MaillistEndpoint.as_view(), name="fan-api-maillist"),
    url(r"^org-account-list$", OrgAccountListEndpoint.as_view(), name="fan-api-org-account-list"),
    url(r"^org-domain-list$", OrgDomainListEndpoint.as_view(), name="fan-api-org-domain-list"),
    url(r"^org-limits$", OrgLimitsEndpoint.as_view(), name="fan-api-org-limits"),
    url(r"^campaign-list$", CampaignListEndpoint.as_view(), name="fan-api-1-campaign-list"),
    url(r"^campaign$", CampaignEndpoint.as_view(), name="fan-api-1-campaign"),
    url(
        r"^campaign-details$", CampaignDetailsEndpoint.as_view(), name="fan-api-1-campaign-details"
    ),
    url(r"^test-send-task$", TestSendTaskEndpoint.as_view(), name="fan-api-1-test-send-task"),
    url(r"^campaign-letter$", CampaignLetterEndpoint.as_view(), name="fan-api-1-campaign-letter"),
    url(
        r"^campaign-maillist$",
        CampaignMailListEndpoint.as_view(),
        name="fan-api-1-campaign-maillist",
    ),
    url(r"^campaign-state$", CampaignStateEndpoint.as_view(), name="fan-api-1-campaign-state"),
    url(
        r"^campaign-html-preview$",
        CampaignHTMLPreviewEndpoint.as_view(),
        name="fan-api-1-campaign-html-preview",
    ),
    url(r"^", CatchallEndpoint.as_view(), name="fan-api-catchall"),
]
