"""
WSGI config for fan project.

It exposes the WSGI callable as a module-level variable named ``application``.

For more information on this file, see
https://docs.djangoproject.com/en/1.7/howto/deployment/wsgi/
"""

import os

try:
    # uwsgi environment
    import fan_ui
    import sys

    sys.path.insert(0, os.path.dirname(fan_ui.__file__))
    os.environ.setdefault("DJANGO_SETTINGS_MODULE", "fan_ui.settings")
except ImportError:
    # runserver
    os.environ.setdefault("DJANGO_SETTINGS_MODULE", "settings")

from django.core.wsgi import get_wsgi_application
from dj_static import Cling

application = Cling(get_wsgi_application())

import fan.app

assert fan.app.check_configuration()
