from fan.models.account import Account


def get_or_create_account(name, org_id):
    account, _ = Account.objects.get_or_create(name=name, defaults={"org_id": org_id})
    if account.org_id != org_id:
        raise Exception(
            "account {} already belongs to another organization {}".format(name, account.org_id)
        )
    return account
