from django.conf import settings


def campaigns_per_day_limit(org_id):
    return settings.CAMPAIGNS_PER_DAY_FOR_ORG.get(org_id, settings.CAMPAIGNS_PER_DAY)


def test_sends_per_day_limit(org_id):
    return settings.TEST_SENDS_PER_DAY_FOR_ORG.get(org_id, settings.TEST_SENDS_PER_DAY)


def draft_campaigns_limit(org_id):
    return settings.DRAFT_CAMPAIGNS_LIMIT_FOR_ORG.get(org_id, settings.DRAFT_CAMPAIGNS_LIMIT)


def maillists_limit(org_id):
    return settings.MAILLISTS_LIMIT_FOR_ORG.get(org_id, settings.MAILLISTS_LIMIT)


def send_emails_limit(org_id):
    if org_id in settings.SEND_EMAILS_LIMIT_FOR_ORG:
        return settings.SEND_EMAILS_LIMIT_FOR_ORG[org_id]
    return None


def trusty(org_id):
    if org_id in settings.TRUSTY_FOR_ORG:
        return settings.TRUSTY_FOR_ORG[org_id]
    return None
