from fan.campaigns.set import clone_campaign_details
from fan.lists.singleuse import clone_csv_for_campaign
from fan.message.letter import clone_letter
from fan.models.campaign import Campaign
from fan.db.decorator import atomic_auto_retry


@atomic_auto_retry
def clone_campaign(user_id, account, source_campaign):
    campaign = create_campaign(
        account=account,
        maillist=source_campaign.maillist,
        owner=user_id,
        type=Campaign.TYPE_SIMPLE,
        state=Campaign.STATUS_DRAFT,
    )
    clone_campaign_details(campaign, source_campaign)
    clone_csv_for_campaign(campaign, source_campaign)
    clone_letter(campaign.default_letter, source_campaign.default_letter)
    return campaign


@atomic_auto_retry
def create_campaign(account, owner="_root", **kw):
    campaign = Campaign()
    campaign.slug = campaign.create_slug()
    campaign.account = account
    campaign.created_by = owner
    _init_campaign_attrs(campaign, account, **kw)
    assert campaign.type in [t for t, _ in Campaign.TYPE_CHOICES]
    campaign.save()
    campaign.create_letter()
    return campaign


def _init_campaign_attrs(campaign, account, **kw):
    attrs = {
        "type": Campaign.TYPE_SIMPLE,
        "state": Campaign.STATUS_DRAFT,
        "project": account.get_default_project(),
        "testing_emails": account.default_testing_emails,
    }
    attrs.update(kw)
    for k, v in list(attrs.items()):
        setattr(campaign, k, v)
