from django.db import transaction
from fan.campaigns.exceptions import ForbiddenCurrentCampaignState
from fan.message.letter import get_letter_attachment_paths, unpublish_letter_attachments_noexcept
from fan.models.campaign import Campaign


def delete_campaign(campaign):
    _validate_campaign_is_draft(campaign)
    letter_attachment_paths = get_letter_attachment_paths(campaign.default_letter)
    _delete_campaign_from_db(campaign)
    unpublish_letter_attachments_noexcept(letter_attachment_paths)


def _validate_campaign_is_draft(campaign):
    if campaign.state != Campaign.STATUS_DRAFT:
        raise ForbiddenCurrentCampaignState(campaign.state, Campaign.STATUS_DRAFT)


@transaction.atomic
def _delete_campaign_from_db(campaign):
    campaign.delete()
