class ForbiddenTargetCampaignState(Exception):
    pass


class ForbiddenCurrentCampaignState(Exception):
    def __init__(self, actual_state, required_state):
        super().__init__("campaign has state %s instead %s" % (actual_state, required_state))
        self.actual_state = actual_state
        self.required_state = required_state


class NoMaillist(Exception):
    pass


class NoLetter(Exception):
    pass


class EmptyFromEmail(Exception):
    pass


class EmptyFromName(Exception):
    pass


class EmptySubject(Exception):
    pass


class DomainNotBelongs(Exception):
    pass


class LoginNotBelongs(Exception):
    pass


class DomainNoMX(Exception):
    pass


class DomainNoDKIM(Exception):
    pass


class DomainNoSPF(Exception):
    pass


class UnsupportedStat(Exception):
    def __init__(self, stat):
        super().__init__("stat %s is not supported" % stat)
        self.stat = stat


class InvalidStatValue(Exception):
    def __init__(self, stat):
        super().__init__("stat %s value is invalid" % stat)
        self.stat = stat


class MismatchedStatsSummary(Exception):
    pass
