from django.conf import settings
from fan.models.campaign import Campaign


def get_campaigns(account_id, states):
    qs = Campaign.objects.filter(account_id=account_id)
    if states is not None and len(states) > 0:
        qs = qs.filter(state__in=list(states))
    return qs.order_by("-created_at")[: settings.CAMPAIGNS_LIST_LIMIT].prefetch_related(
        "letters_rel"
    )


def get_campaigns_to_send(count):
    if count <= 0:
        raise RuntimeError("count must be greater than 0")
    qs = Campaign.objects.filter(state=Campaign.STATUS_SENDING).order_by("-created_at")
    return qs[:count]
