import re

from django.core.validators import RegexValidator
from django.db.models.fields import SlugField
from django.utils.translation import ugettext_lazy as _

slug_dot_re = re.compile(r"^[-a-zA-Z0-9_\.]+$")
validate_slug_dot = RegexValidator(
    slug_dot_re,
    _("Enter a valid 'slug' consisting of letters, numbers, underscores, hyphens or dots."),
    "invalid",
)


class SlugDotField(SlugField):
    """
    slug, который разрешает точки.
    """

    default_validators = [validate_slug_dot]
