from django.db.models import Manager
from django.db.models.signals import class_prepared, post_delete, post_save


class BaseManager(Manager):
    lookup_handlers = {
        "iexact": lambda x: x.upper(),
    }
    use_for_related_fields = True

    def __class_prepared(self, sender, **kwargs):
        post_save.connect(self.post_save, sender=sender, weak=False)
        post_delete.connect(self.post_delete, sender=sender, weak=False)

    def post_save(self, instance, **kwargs):
        """
        Triggered when a model bound to this manager is saved.
        """

    def post_delete(self, instance, **kwargs):
        """
        Triggered when a model bound to this manager is deleted.
        """

    def contribute_to_class(self, model, name):
        super().contribute_to_class(model, name)
        class_prepared.connect(self.__class_prepared, sender=model)
