from django.db import DatabaseError, OperationalError

import psycopg2

CONNECTION_ERRORS = (
    psycopg2.InterfaceError,
    psycopg2.DatabaseError,
    OperationalError,
    DatabaseError,
)


def is_connection_exception(exc):
    if isinstance(exc, psycopg2.InterfaceError):
        return True
    elif (
        isinstance(exc, psycopg2.DatabaseError)
        or isinstance(exc, DatabaseError)
        or isinstance(exc, OperationalError)
    ):
        exc_msg = str(exc)
        if "query_wait_timeout" in exc_msg:
            return False
        if "server closed the connection unexpectedly" in exc_msg:
            return True
        elif "SSL SYSCALL error: EOF detected" in exc_msg:
            return True
        elif "SSL connection has been closed unexpectedly" in exc_msg:
            return True
        elif "client_idle_timeout" in exc_msg:
            return True
        elif "cannot execute" in exc_msg and "in a read-only transaction" in exc_msg:
            # Мастер стал слейвом
            return True
        elif "Connection refused" in exc_msg:
            # Мастер упал
            return True

    return False


def can_reconnect(connection, exc):
    if connection.in_atomic_block:
        # Если мы внтури транзакции нельзя просто переподключиться
        return False

    return is_connection_exception(exc)
