from django.utils.translation import ugettext_lazy as _


class DeliveryStatus:
    EMAIL_SENT = 0
    NO_EMAIL = 1
    EMAIL_UPLOADED = 2
    CAMPAIGN_CANCELLED = 100
    CAMPAIGN_OBSOLETE = 101
    EMAIL_UNSUBSCRIBED = 200
    EMAIL_BOUNCED = 201
    EMAIL_INVALID = 202
    EMAIL_IN_CONTROL_GROUP = 203
    NETWORK_ERROR = 400
    STORAGE_ERROR = 401
    EMAIL_DUPLICATED = 666
    RENDER_MESSAGE_TIMEOUT = 800
    UNDEFINED_ERROR = 999

    CHOICES = (
        (EMAIL_SENT, _("Письмо отправлено")),
        (NO_EMAIL, _("Не указан email")),
        (EMAIL_UPLOADED, _("Адрес загружен")),
        (UNDEFINED_ERROR, _("Неизвестная ошибка")),
        (EMAIL_UNSUBSCRIBED, _("Адрес отписан")),
        (EMAIL_BOUNCED, _("Адрес не принимает почту (bounced)")),
        (EMAIL_IN_CONTROL_GROUP, _("Адрес попал в контрольную группу")),
        (CAMPAIGN_CANCELLED, _("Рассылка остановлена")),
        (CAMPAIGN_OBSOLETE, _("Рассылка устарела")),
        (EMAIL_DUPLICATED, _("Дублированный email")),
        (EMAIL_INVALID, _("Неверный email")),
        (NETWORK_ERROR, _("Ошибка сети")),
        (STORAGE_ERROR, _("Нет места в ящике")),
        (RENDER_MESSAGE_TIMEOUT, _("Превышено ограничение на время рендеринга сообщения")),
    )

    # count(EMAIL_SUCCESSFULLY_SENT) = count(EMAIL_UPLOADED) - count(EMAIL_SEND_FAILED_STATUSES)
    EMAIL_SEND_FAILED_STATUSES = (
        EMAIL_UNSUBSCRIBED,
        EMAIL_DUPLICATED,
        EMAIL_INVALID,
        UNDEFINED_ERROR,
    )
