class BaseTemplate:
    def __init__(self, template_text, **kwargs):
        self.set_template_text(template_text)
        self.kwargs = kwargs

    def set_template_text(self, template_text):
        self.template_text = template_text
        self._template = None

    def render(self, **kwargs):
        raise NotImplementedError

    def compile_template(self):
        raise NotImplementedError

    @property
    def template(self):
        if self._template is None:
            self._template = self.compile_template()
        return self._template
