from django.db import migrations, models
import jsonfield.fields


class Migration(migrations.Migration):

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        ("fan", "__first__"),
    ]

    operations = [
        migrations.CreateModel(
            name="IgnoreRestrictionsSchedulingRequest",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                (
                    "request_from",
                    models.CharField(
                        max_length=128,
                        verbose_name="\u0410\u0432\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430",
                    ),
                ),
                (
                    "date_to_send",
                    models.DateTimeField(
                        verbose_name="\u0414\u0430\u0442\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438"
                    ),
                ),
                (
                    "reason",
                    models.TextField(verbose_name="\u041f\u0440\u0438\u0447\u0438\u043d\u0430"),
                ),
                ("data", jsonfield.fields.JSONField(default=dict, null=True)),
                (
                    "moderated_by",
                    models.CharField(
                        max_length=128,
                        null=True,
                        verbose_name="\u041c\u043e\u0434\u0435\u0440\u0430\u0442\u043e\u0440",
                    ),
                ),
                (
                    "decision",
                    models.CharField(
                        max_length=16,
                        null=True,
                        verbose_name="\u0420\u0435\u0448\u0435\u043d\u0438\u0435",
                        choices=[
                            (
                                None,
                                "\u041d\u0435 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e",
                            ),
                            (
                                "approved",
                                "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043e",
                            ),
                            ("rejected", "\u041e\u0442\u043a\u043b\u043e\u043d\u0435\u043d\u043e"),
                        ],
                    ),
                ),
                (
                    "campaign",
                    models.ForeignKey(
                        related_name="ignore_restrictions_requests",
                        verbose_name="\u0420\u0430\u0441\u0441\u044b\u043b\u043a\u0430",
                        to="fan.Campaign",
                    ),
                ),
            ],
            options={
                "verbose_name": "\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u043e\u0431\u0445\u043e\u0434 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0439",
                "verbose_name_plural": "\u0417\u0430\u043f\u0440\u043e\u0441\u044b \u043d\u0430 \u043e\u0431\u0445\u043e\u0434 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0439",
            },
        ),
        migrations.CreateModel(
            name="RestrictionGroup",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                (
                    "name",
                    models.CharField(
                        max_length=255,
                        verbose_name="\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435",
                    ),
                ),
                (
                    "accounts",
                    models.ManyToManyField(
                        related_name="groups",
                        verbose_name="\u0410\u043a\u043a\u0430\u0443\u043d\u0442\u044b",
                        to="fan.Account",
                    ),
                ),
            ],
            options={
                "verbose_name": "\u0413\u0440\u0443\u043f\u043f\u0430 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u043e\u0432",
                "verbose_name_plural": "\u0413\u0440\u0443\u043f\u043f\u044b \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u043e\u0432",
            },
        ),
        migrations.CreateModel(
            name="ScheduledRecipients",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                ("scheduling_process_mark", models.CharField(max_length=1024, null=True)),
                ("data", models.BinaryField()),
                (
                    "data_encoding",
                    models.CharField(default="gzip", max_length=16, choices=[("gzip", "gzip")]),
                ),
                (
                    "number_of_recipients",
                    models.PositiveIntegerField(
                        verbose_name="\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u0435\u0439"
                    ),
                ),
                (
                    "date_to_send",
                    models.DateTimeField(
                        null=True,
                        verbose_name="\u0421\u043e\u0433\u043b\u0430\u0441\u043e\u0432\u0430\u043d\u043d\u0430\u044f \u0434\u0430\u0442\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438",
                    ),
                ),
                (
                    "sent_to_delivery",
                    models.BooleanField(
                        default=False,
                        verbose_name="\u041f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u044b \u043d\u0430 \u0434\u043e\u0441\u0442\u0430\u0432\u043a\u0443",
                    ),
                ),
                (
                    "is_ab_second_part",
                    models.BooleanField(
                        default=False,
                        verbose_name="\u0417\u0430\u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0430, \u043a\u0430\u043a \u043e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u0447\u0430\u0441\u0442\u044c A/B",
                    ),
                ),
                (
                    "extra",
                    jsonfield.fields.JSONField(
                        default=dict,
                        verbose_name="\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0444\u043b\u0430\u0433\u0438",
                    ),
                ),
                (
                    "campaign",
                    models.ForeignKey(
                        verbose_name="\u0420\u0430\u0441\u0441\u044b\u043b\u043a\u0430",
                        to="fan.Campaign",
                    ),
                ),
            ],
            options={
                "verbose_name": "\u0417\u0430\u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0435 \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u0438",
                "verbose_name_plural": "\u0417\u0430\u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0435 \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u0438",
            },
        ),
        migrations.CreateModel(
            name="SchedulingFailedRecipients",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                ("email", models.CharField(max_length=255, blank=True)),
                (
                    "parameters",
                    jsonfield.fields.JSONField(
                        default=dict,
                        verbose_name="\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b",
                    ),
                ),
                (
                    "reason",
                    models.CharField(
                        max_length=255,
                        verbose_name="\u041f\u0440\u0438\u0447\u0438\u043d\u0430 \u043e\u0448\u0438\u0431\u043a\u0438",
                        blank=True,
                    ),
                ),
                (
                    "campaign",
                    models.ForeignKey(
                        related_name="scheduling_failed",
                        verbose_name="\u0420\u0430\u0441\u0441\u044b\u043b\u043a\u0430",
                        to="fan.Campaign",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "\u041d\u0435\u0432\u0430\u043b\u0438\u0434\u043d\u044b\u0435 \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u0438",
            },
        ),
        migrations.CreateModel(
            name="SchedulingLock",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                ("params", jsonfield.fields.JSONField(null=True)),
                ("campaign", models.ForeignKey(to="fan.Campaign")),
            ],
            options={
                "verbose_name": "\u041b\u043e\u043a \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0430 \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f",
                "verbose_name_plural": "\u041b\u043e\u043a\u0438 \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0430 \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f",
            },
        ),
        migrations.CreateModel(
            name="SchedulingResult",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                (
                    "data",
                    jsonfield.fields.JSONField(
                        default={}, verbose_name="\u0414\u0430\u043d\u043d\u044b\u0435"
                    ),
                ),
                (
                    "campaign",
                    models.ForeignKey(
                        related_name="scheduling_results",
                        verbose_name="\u0420\u0430\u0441\u0441\u044b\u043b\u043a\u0430",
                        to="fan.Campaign",
                    ),
                ),
            ],
            options={
                "verbose_name": "\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438",
                "verbose_name_plural": "\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438",
            },
        ),
        migrations.CreateModel(
            name="SchedulingStats",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                (
                    "processed",
                    models.PositiveIntegerField(
                        default=0,
                        verbose_name="\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e",
                    ),
                ),
                (
                    "scheduled",
                    models.PositiveIntegerField(
                        default=0,
                        verbose_name="\u0417\u0430\u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043e",
                    ),
                ),
                (
                    "not_scheduled",
                    models.PositiveIntegerField(
                        default=0,
                        verbose_name="\u041d\u0435 \u0437\u0430\u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043e",
                    ),
                ),
                (
                    "errors",
                    models.PositiveIntegerField(
                        default=0,
                        verbose_name="\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430",
                    ),
                ),
                (
                    "campaign",
                    models.OneToOneField(
                        related_name="scheduling_stats",
                        verbose_name="\u0420\u0430\u0441\u0441\u044b\u043b\u043a\u0430",
                        to="fan.Campaign",
                    ),
                ),
            ],
            options={
                "verbose_name": "\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f",
                "verbose_name_plural": "\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f",
            },
        ),
        migrations.CreateModel(
            name="SpamRestriction",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                ("object_id", models.PositiveIntegerField()),
                (
                    "type",
                    models.CharField(
                        max_length=64,
                        verbose_name="\u0422\u0438\u043f",
                        choices=[
                            ("daily", "\u0412 \u0434\u0435\u043d\u044c"),
                            ("weekly", "\u0412 \u043d\u0435\u0434\u0435\u043b\u044e"),
                            ("monthly", "\u0412 \u043c\u0435\u0441\u044f\u0446"),
                        ],
                    ),
                ),
                (
                    "value",
                    models.PositiveIntegerField(
                        verbose_name="\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u0438\u0441\u0435\u043c"
                    ),
                ),
                ("content_type", models.ForeignKey(to="contenttypes.ContentType")),
            ],
            options={
                "verbose_name": "\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u0441\u043f\u0430\u043c",
                "verbose_name_plural": "\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f \u043d\u0430 \u0441\u043f\u0430\u043c",
            },
        ),
        migrations.AlterUniqueTogether(
            name="spamrestriction",
            unique_together=set([("content_type", "object_id", "type")]),
        ),
    ]
