from django.db import migrations, models
import jsonfield.fields


class Migration(migrations.Migration):

    dependencies = [
        ("fan", "__first__"),
    ]

    operations = [
        migrations.CreateModel(
            name="CampaignSegment",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                (
                    "update_on_send",
                    models.BooleanField(
                        default=False,
                        help_text="\u041f\u0435\u0440\u0435\u0441\u0447\u0438\u0442\u0430\u0442\u044c \u043f\u0435\u0440\u0435\u0434 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u043e\u0439",
                    ),
                ),
                (
                    "interface",
                    models.CharField(
                        blank=True,
                        max_length=20,
                        null=True,
                        choices=[
                            (
                                "singleuse",
                                "\u041e\u0434\u043d\u043e\u0440\u0430\u0437\u043e\u0432\u044b\u0439 \u0441\u043f\u0438\u0441\u043e\u043a",
                            ),
                            (
                                "maillist",
                                "\u0421\u043f\u0438\u0441\u043a\u0438 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438",
                            ),
                            (
                                "segments",
                                "\u041a\u043e\u043d\u0441\u0442\u0440\u0443\u043a\u0442\u043e\u0440 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u043e\u0432",
                            ),
                        ],
                    ),
                ),
                (
                    "campaign",
                    models.OneToOneField(related_name="segment_relation", to="fan.Campaign"),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Segment",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                ("created_by", models.CharField(max_length=128)),
                (
                    "shared",
                    models.BooleanField(
                        default=False,
                        help_text="\u041c\u043e\u0436\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0440\u0430\u0437",
                    ),
                ),
                (
                    "schema",
                    jsonfield.fields.JSONField(
                        default=dict,
                        verbose_name="\u0421\u0445\u0435\u043c\u0430 \u0440\u0430\u0441\u0441\u0447\u0435\u0442\u0430",
                    ),
                ),
                ("description", models.TextField(default="", blank=True)),
                ("deleted", models.BooleanField(default=False)),
                ("slug", models.SlugField(max_length=192, db_index=False)),
                ("account", models.ForeignKey(related_name="segment_set", to="fan.Account")),
            ],
            options={
                "verbose_name_plural": "\u0421\u0435\u0433\u043c\u0435\u043d\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0441\u043f\u0438\u0441\u043e\u043a \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438",
            },
        ),
        migrations.CreateModel(
            name="SegmentList",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                ("created_by", models.CharField(max_length=128)),
                (
                    "file_type",
                    models.CharField(
                        max_length=32,
                        verbose_name="\u0422\u0438\u043f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430",
                        choices=[
                            ("source", "\u0438\u0441\u0445\u043e\u0434\u043d\u044b\u0439"),
                            ("temp", "\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0439"),
                            ("result", "\u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442"),
                        ],
                    ),
                ),
                (
                    "file_name",
                    models.CharField(
                        max_length=255,
                        verbose_name="\u0418\u043c\u044f \u0444\u0430\u0439\u043b\u0430",
                    ),
                ),
                ("data", models.FileField(null=True, upload_to="segments/%Y/%m/%d/")),
                (
                    "list_meta",
                    jsonfield.fields.JSONField(
                        default=dict,
                        verbose_name="\u041c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0435 \u0441\u043f\u0438\u0441\u043a\u0430",
                    ),
                ),
                (
                    "s3meta",
                    jsonfield.fields.JSONField(
                        default=dict,
                        verbose_name="\u041c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0435 S3",
                    ),
                ),
                ("deleted", models.BooleanField(default=False)),
                ("account", models.ForeignKey(related_name="file_set", to="fan.Account")),
                (
                    "segment",
                    models.ForeignKey(
                        related_name="file_set", to="fan_segments.Segment", null=True
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "\u0424\u0430\u0439\u043b \u0441\u043f\u0438\u0441\u043a\u0430 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0430",
            },
        ),
        migrations.CreateModel(
            name="SegmentRun",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                ("created_by", models.CharField(max_length=128)),
                (
                    "schema",
                    jsonfield.fields.JSONField(
                        default=dict,
                        verbose_name="\u0421\u0445\u0435\u043c\u0430 \u0440\u0430\u0441\u0441\u0447\u0435\u0442\u0430",
                    ),
                ),
                (
                    "stats",
                    jsonfield.fields.JSONField(
                        default=dict,
                        verbose_name="\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u0440\u0430\u0441\u0441\u0447\u0435\u0442\u0430",
                    ),
                ),
                (
                    "state",
                    models.CharField(
                        default="created",
                        max_length=32,
                        choices=[
                            ("created", "\u0441\u043e\u0437\u0434\u0430\u043d"),
                            ("running", "\u0437\u0430\u043f\u0443\u0449\u0435\u043d"),
                            ("done", "\u0440\u0430\u0441\u0441\u0447\u0438\u0442\u0430\u043d"),
                            ("error", "\u043e\u0448\u0438\u0431\u043a\u0430"),
                            ("canceled", "\u043e\u0442\u043c\u0435\u043d\u0435\u043d"),
                        ],
                    ),
                ),
                ("segment", models.ForeignKey(related_name="run_set", to="fan_segments.Segment")),
            ],
            options={
                "verbose_name_plural": "\u0420\u0430\u0441\u0447\u0435\u0442 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u0441\u043f\u0438\u0441\u043a\u0430 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438",
            },
        ),
        migrations.AddField(
            model_name="segmentlist",
            name="segment_run",
            field=models.ForeignKey(
                related_name="file_set", to="fan_segments.SegmentRun", null=True
            ),
        ),
        migrations.AddField(
            model_name="campaignsegment",
            name="segment",
            field=models.ForeignKey(
                related_name="campaign_set", to="fan_segments.Segment", null=True
            ),
        ),
        migrations.AddField(
            model_name="campaignsegment",
            name="segment_run",
            field=models.ForeignKey(
                related_name="campaign_set", to="fan_segments.SegmentRun", null=True
            ),
        ),
        migrations.AlterUniqueTogether(
            name="segment",
            unique_together=set([("account", "slug")]),
        ),
    ]
