import logging

from fan.models import AccountUnsubscribeList, Campaign
from fan.utils.cached_getters import get_campaign


def make_campaign_unsubscribe(
    campaign_id, email, letter_id, reason=None, request_data=None, logger=None
):
    """
    Отписка в случае, когда определена кампания для которой отписываем

    """
    # Добавляем email во все списки отписки
    try:
        campaign = get_campaign(campaign_id)
        for unsub_lst in campaign.unsubscribe_lists.all():
            unsub_lst.upsert_element(email=email)
    except Campaign.DoesNotExist:
        logging.warning("Wrong campaign id:%s on unsubscribe request", campaign_id)
    except ValueError:
        logging.warning("Wrong value for unsubscribe email: %s", email)


def make_general_unsubscribe(campaign_id, email):
    """
    Добавление в общий для аккаунта список отписки
    """
    try:
        campaign = get_campaign(campaign_id)
        unsub_list = campaign.account.unsubscribe_lists.filter(general=True).first()
        unsub_list.upsert_element(email=email)
    except Campaign.DoesNotExist:
        logging.warning("Wrong campaign id:%s on unsubscribe request", campaign_id)
    except AccountUnsubscribeList.DoesNotExist:
        logging.warning("General unsubscribe list does not exists for campaign id:%s", campaign_id)
