def add_pixel(message):
    message.transformer.replace_old_pixel()
    if "{% opens_counter %}" not in message.transformer.html:
        message.transformer.append_to_body("{% opens_counter %}")
    message.transformer.save()


def tag_images(message):
    message.transformer.apply_to_images(func=_wrap_image_src)
    message.transformer.save()


def get_local_images_urls_from_html(message):
    urls = []

    def callback(url, **kw):
        if _is_local_image_url(url):
            urls.append(url)
        return url

    message.transformer.apply_to_images(func=callback)
    return urls


def get_web_images_urls_from_html(message):
    urls = []

    def callback(url, **kw):
        if _link_wrapable(url):
            urls.append(url)
        return url

    message.transformer.apply_to_images(func=callback)
    return urls


def substitute_images_paths(message, substitute_paths):
    def callback(url, **kw):
        if url in list(substitute_paths.keys()):
            return substitute_paths[url]
        return url

    message.transformer.apply_to_images(func=callback)
    message.transformer.save()


def _wrap_image_src(src, **kw):
    if _link_wrapable(src) or _is_template(src):
        return src

    if _is_base_64_image_link(src):
        # do not wrap base64 images in tag
        return src

    return '{{% autoloaded_file "{src}" %}}'.format(src=src)


def _link_wrapable(url):
    return bool(url and url.lstrip().startswith("http"))


def _is_template(url):
    return bool(url and "{" in url)


def _is_base_64_image_link(src):
    return src and src.lstrip().startswith("data:image")


def _is_local_image_url(url):
    return not _link_wrapable(url) and not _is_template(url) and not _is_base_64_image_link(url)
