import re
from django.conf import settings

from fan.utils.crypt import default_encoder, encoders

UNSUBSCRIBE_HOST = getattr(settings, "SENDR_UNSUBSCRIBE_HOST", None)

UNSUBSCRIBE_LINK = "unsubscribe_link"
GLOBAL_UNSUBSCRIBE_LINK = "global_unsubscribe_link"


def search_unsubscribe_link(text):
    return re.search(r"{{[\s]*%s[\s]*}}" % UNSUBSCRIBE_LINK, text)


def encode_unsubscribe_code2(email, campaign_id, letter_id=None, message_id="", for_testing=False):
    code = "%s:%s:%s:%s" % (email, campaign_id, letter_id or 0, message_id)
    test_code = "T" if for_testing else ""
    return "%s%s/%s" % (test_code, default_encoder.code, default_encoder.encode(code))


class DecodeError(Exception):
    pass


def decode_unsubscribe_code2(code):
    encoderid, token = code.split("/", 1)
    for_testing = False
    if encoderid.startswith("T"):
        for_testing = True
        encoderid = encoderid[1:]
    if encoderid not in encoders:
        raise DecodeError('Error decoding "%s"' % code)
    encoder = encoders[encoderid]
    email, suffix = encoder.decode(token).split(":", 1)
    if ":" in suffix:
        decoded = suffix.split(":", 2)
        if len(decoded) == 3:
            campaign_id, letter_id, message_id = decoded
        else:
            campaign_id, letter_id = decoded
            message_id = None
        letter_id = int(letter_id)
    else:
        campaign_id = suffix
        letter_id = None
        message_id = None
    return email, int(campaign_id), letter_id, message_id, for_testing


def get_unsubscribe_link(secret_code):
    """Unsubscribe link"""
    return "{}unsubscribe/{}".format(UNSUBSCRIBE_HOST, secret_code)


def get_unsubscribe_links(render_context, letter_secret, allow_custom=False):
    links = {UNSUBSCRIBE_LINK: get_unsubscribe_link(letter_secret)}
    links[GLOBAL_UNSUBSCRIBE_LINK] = links[UNSUBSCRIBE_LINK] + "?type=global"

    if allow_custom:
        preset = {
            key: render_context.get(key)
            for key in (UNSUBSCRIBE_LINK, GLOBAL_UNSUBSCRIBE_LINK)
            if render_context.get(key) is not None
        }
        links.update(preset)

    return links
