from fan.models import UnsubscribeListElement
from fan.utils.cached_getters import get_campaign_unsubscribe_lists_id


def get_unsubscribed_emails_for_campaign(campaign, filter_emails=None):
    unsubscribe_lists = get_campaign_unsubscribe_lists_id(campaign.id)
    filters = {"list_id__in": unsubscribe_lists}
    if filter_emails is not None:
        filters["email__upperin"] = filter_emails
    emails = UnsubscribeListElement.objects.filter(**filters).values_list("email", flat=True)
    return emails


def get_unsubscribed_emails_among(account, emails):
    return set(UnsubscribeListElement.objects.filter(
        list__account=account, email__in=emails
    ).values_list("email", flat=True))
