from fan.message.loader import from_html, from_zip
from fan.links.statistic_wrapper import add_pixel


def do_add_stat_pixel(message):
    """
    Добавляем пиксель статбокса в письмо.

    :param message: сообщение fan.message.Message
    :return:
    """
    return add_pixel(message)


def load_message_from_file(letter, file):
    """
    Загружаем сообщение из файла и фиксим его.

    :param letter: объект fan.models.Letter
    :param file: файл с телом
    """
    from zipfile import is_zipfile

    if is_zipfile(file):
        file_type = "zip"
        message = from_zip(file)
    else:
        file_type = "html"
        message = from_html(file)

    return file_type, message
