import codecs

import fan.emails.loader
from fan.emails.loader.local_store import ZipLoader

from .message import SendrBaseMessage


class SendrZipLoader(ZipLoader):
    def get_file(self, name):
        data, name = super().get_file(name)

        if data.startswith(codecs.BOM_UTF8):
            data = data.decode("utf-8-sig")
        return data, name


def check_image_callback(el, hints):
    # TODO: этот колбэк будет работать в python-emails>=0.5.2
    # Здесь надо проверять и не скачивать распространённые счетчики (метрика, статфейс и тп)
    if hints.get("attrib") == "ignore":
        # не загружать если есть атрибут в html
        return False
    if hasattr(el, "attrib"):
        uri = el.attrib.get("src")
    elif hasattr(el, "uri"):
        uri = el.uri
    else:
        # такого не должно быть, но на всякий случай
        return True

    if uri and (uri.startswith("http://") or uri.startswith("https://")):
        # Не загружать, если это абсолютная ссылка
        return False

    if uri and uri.startswith("data:image"):
        # do not load base64 images
        return False

    return True


DEFAULT_LOADER_PARAMS = dict(
    css_inline=False,
    remove_unsafe_tags=True,
    set_content_type_meta=True,
    images_inline=False,
    load_images=check_image_callback,
    message_cls=SendrBaseMessage,
    keep_style_tags=True,
    remove_classes=False,
)


class HTMLWrongFormat(Exception):
    pass


def from_zip(f):
    try:
        return fan.emails.loader.from_zip(f, loader_cls=SendrZipLoader, **DEFAULT_LOADER_PARAMS)
    except fan.emails.loader.LoadError:
        raise HTMLWrongFormat


def from_html(f):
    try:
        f.seek(0)
        html = f.read()
        return fan.emails.loader.from_html(html=html, **DEFAULT_LOADER_PARAMS)
    except (UnicodeDecodeError, fan.emails.loader.LoadError):
        raise HTMLWrongFormat


def from_string(html):
    try:
        return fan.emails.loader.from_html(html=html, **DEFAULT_LOADER_PARAMS)
    except fan.emails.loader.LoadError:
        raise HTMLWrongFormat
