from fan.message.message import make_testing_subject, make_letter_secret
from fan.message.body_upload import do_add_stat_pixel
from .get import get_message_by_letter_id, get_message_by_letter
from fan.links.unsubscribe import encode_unsubscribe_code2
from fan.utils.so import get_so_headers
from fan.emails.utils import MessageID


RECIPIENT_EML_PLACEHOLDER = "%recipient%"
LETTER_SECRET_EML_PLACEHOLDER = "%secret%"
PREVIEW_FAKE_RECIPIENT = "preview@example.ru"


def render_eml(campaign):
    letter = campaign.default_letter
    message = get_message_by_letter_id(letter.id)
    do_add_stat_pixel(message)
    message.letter_secret = LETTER_SECRET_EML_PLACEHOLDER
    message.mail_to = RECIPIENT_EML_PLACEHOLDER
    message.add_headers(get_so_headers(campaign), replace=True, allow_so_headers=True)
    message.set_user_template_variable_values(_make_render_data(message))
    return message.as_message().as_string()


def render_test_eml(campaign, recipient, user_template_variables={}):
    letter = campaign.default_letter
    message = get_message_by_letter_id(letter.id)
    do_add_stat_pixel(message)
    message.letter_secret = make_letter_secret(
        email=recipient,
        letter=letter,
        message=message,
        for_testing=True,
    )
    message.subject_template_text = make_testing_subject(letter, message.subject_template_text)
    message.mail_to = recipient
    message.add_headers(get_so_headers(campaign), replace=True, allow_so_headers=True)
    message.set_user_template_variable_values(user_template_variables)
    return message.as_message().as_string()


def render_preview_html(campaign):
    letter = campaign.default_letter
    message = get_message_by_letter_id(letter.id)
    do_add_stat_pixel(message)
    message.letter_secret = make_letter_secret(
        email=PREVIEW_FAKE_RECIPIENT,
        letter=letter,
        message=message,
        for_testing=True,
    )
    message.mail_to = PREVIEW_FAKE_RECIPIENT
    message.set_user_template_variable_values(_make_preview_render_data(message))
    message.build_message()
    return message.html_body


def test_render(letter):
    message = get_message_by_letter(letter)
    message.letter_secret = make_letter_secret(
        email=PREVIEW_FAKE_RECIPIENT,
        letter=letter,
        message=message,
        for_testing=True,
    )
    do_add_stat_pixel(message)
    message.mail_to = PREVIEW_FAKE_RECIPIENT
    message.add_headers(get_so_headers(letter.campaign), replace=True, allow_so_headers=True)
    message.build_message()
    return message


def generate_rendering_params(campaign_id, letter_id, recipient):
    return {
        "recipient": recipient,
        "secret": encode_unsubscribe_code2(recipient, campaign_id, letter_id, MessageID()),
    }


def _make_preview_render_data(message):
    data = {}
    for variable_name in message.user_template_variables:
        data[variable_name] = "{{ %s }}" % variable_name
    return data


def _make_render_data(message):
    data = {}
    for variable_name in message.user_template_variables:
        # Prefix prevents intersection of user template variable names with system placeholders,
        # i.e. %recipient% and %secret%
        data[variable_name] = "%user_variable_{}%".format(variable_name)
    return data
