from django.utils.functional import cached_property

import jinja2
import jinja2.meta
import jinja2.sandbox
from fan.emails.template import JinjaTemplate
from fan.emails.template.base import BaseTemplate
from fan.message.env import env


BUILTIN_TEMPLATE_VARIABLES = frozenset(
    (
        "unsubscribe_link",
        "global_unsubscribe_link",
        "subscribe_link",
        "__UTM__",
        "__UTM_ONLY__",
        "sender_letter_code",
        "sender_letter_id",
        "sender_campaign_id",
        "sender_letter_secret",
    )
)


class Template(JinjaTemplate):
    def __init__(self, text):
        super().__init__(text, environment=env)

    @cached_property
    def _undeclared_variables(self):
        return jinja2.meta.find_undeclared_variables(self.environment.parse(self.template_text))

    @property
    def user_template_variables(self):
        """Возвращает список пользовательских переменных шаблона."""
        return [x for x in self._undeclared_variables if x not in BUILTIN_TEMPLATE_VARIABLES]

    @property
    def builtin_template_variables(self):
        """Возвращает список встроенных переменных шаблона."""
        return [x for x in self._undeclared_variables if x in BUILTIN_TEMPLATE_VARIABLES]


# We do not need to render subject, but emails library requires BaseTemplate interface
class DummyTemplate(BaseTemplate):
    def __init__(self, text):
        self.template_text = text

    def render(self, **kwargs):
        return self.template_text

    @property
    def user_template_variables(self):
        return []

    @property
    def builtin_template_variables(self):
        return []
