from django.db import migrations, models
import bitfield.models
import jsonfield.fields
import fan.db.fields.separatedvaluesfield
import fan.db.fields.pickle
import fan.db.fields.slug
import django.utils.timezone
from django.conf import settings
import django.contrib.postgres.fields.hstore
import storages.backends.s3boto3
import fan.models.letter


class Migration(migrations.Migration):

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Account",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                ("org_id", models.CharField(max_length=256, db_index=True)),
                ("name", models.SlugField(unique=True, max_length=192, db_index=False)),
                ("title", models.CharField(max_length=256)),
                (
                    "default_testing_emails",
                    fan.db.fields.separatedvaluesfield.SeparatedValuesField(
                        max_length=1024, null=True, blank=True
                    ),
                ),
                (
                    "allow_custom_unsubscribe_link",
                    models.BooleanField(
                        default=False,
                        help_text="\u0420\u0430\u0437\u0440\u0435\u0448\u0438\u0442\u044c \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0443 \u0437\u0430\u0434\u0430\u0432\u0430\u0442\u044c \u0441\u0432\u043e\u044e \u0441\u0441\u044b\u043b\u043a\u0443 \u043e\u0442\u043f\u0438\u0441\u043a\u0438 \u0432 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0435 \u0440\u0435\u043d\u0434\u0435\u0440\u0438\u043d\u0433\u0430 \u043f\u0438\u0441\u044c\u043c\u0430",
                    ),
                ),
                (
                    "status_store_period",
                    models.IntegerField(
                        default=0,
                        verbose_name="\u0412\u0440\u0435\u043c\u044f \u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "\u0421\u0435\u0440\u0432\u0438\u0441",
            },
        ),
        migrations.CreateModel(
            name="AccountDomain",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("name", models.CharField(max_length=255)),
                ("confirmed", models.BooleanField(default=False)),
                ("account", models.ForeignKey(related_name="domains", to="fan.Account")),
            ],
        ),
        migrations.CreateModel(
            name="AccountMember",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                (
                    "role",
                    models.CharField(
                        default=b"user",
                        max_length=32,
                        choices=[
                            (b"member", b"Member"),
                            (b"user", b"User"),
                            (b"moderator", b"Moderator"),
                            (b"owner", b"Owner"),
                            (b"assessor_tester", b"Assessor Tester"),
                            (b"assessor_moderator", b"Assessor Moderator"),
                        ],
                    ),
                ),
                ("date_added", models.DateTimeField(default=django.utils.timezone.now)),
                ("has_global_access", models.BooleanField(default=True)),
                ("counter", models.PositiveIntegerField(null=True, blank=True)),
                (
                    "account",
                    models.ForeignKey(related_name="member_set", to="fan.Account", null=True),
                ),
            ],
            options={
                "db_table": "fan_accountmember",
            },
        ),
        migrations.CreateModel(
            name="AccountMemberProject",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("is_active", models.BooleanField(default=True)),
                ("accountmember", models.ForeignKey(to="fan.AccountMember")),
            ],
            options={
                "db_table": "fan_accountmember_project",
            },
        ),
        migrations.CreateModel(
            name="AccountUnsubscribeList",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                (
                    "name",
                    jsonfield.fields.JSONField(
                        default=dict,
                        verbose_name="\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435",
                    ),
                ),
                ("slug", models.SlugField(max_length=192, db_index=False)),
                (
                    "visible",
                    models.BooleanField(
                        default=False,
                        verbose_name="\u041e\u0442\u0434\u0430\u0432\u0430\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0432\u043e \u0432\u043d\u0435\u0448\u043d\u0435\u0435 API",
                    ),
                ),
                (
                    "description",
                    jsonfield.fields.JSONField(
                        null=True,
                        verbose_name="\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435",
                        blank=True,
                    ),
                ),
                (
                    "counter",
                    models.PositiveIntegerField(
                        default=0,
                        verbose_name="\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043e\u0442\u043f\u0438\u0441\u043e\u043a",
                    ),
                ),
                (
                    "created_by",
                    models.CharField(max_length=64, null=True, editable=False, blank=True),
                ),
                (
                    "default",
                    models.BooleanField(
                        default=False,
                        verbose_name="\u0421\u043f\u0438\u0441\u043e\u043a \u043f\u043e-\u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e",
                    ),
                ),
                (
                    "general",
                    models.BooleanField(
                        default=False,
                        verbose_name="\u0413\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u044b\u0439 \u0441\u043f\u0438\u0441\u043e\u043a \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430",
                    ),
                ),
                (
                    "account",
                    models.ForeignKey(
                        related_name="unsubscribe_lists",
                        verbose_name="\u0410\u043a\u043a\u0430\u0443\u043d\u0442",
                        to="fan.Account",
                    ),
                ),
            ],
            options={
                "verbose_name": "\u0421\u043f\u0438\u0441\u043e\u043a \u043e\u0442\u043f\u0438\u0441\u043a\u0438",
                "verbose_name_plural": "\u0421\u043f\u0438\u0441\u043a\u0438 \u043e\u0442\u043f\u0438\u0441\u043a\u0438",
            },
        ),
        migrations.CreateModel(
            name="ApiKey",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("label", models.CharField(default=b"Default", max_length=64, blank=True)),
                ("key", models.CharField(unique=True, max_length=32)),
                (
                    "scopes",
                    bitfield.models.BitField(
                        (
                            (b"project:read", b"project:read"),
                            (b"project:write", b"project:write"),
                            (b"project:delete", b"project:delete"),
                            (b"account:read", b"account:read"),
                            (b"account:write", b"account:write"),
                            (b"account:delete", b"account:delete"),
                            (b"campaign:read", b"campaign:read"),
                            (b"campaign:write", b"campaign:write"),
                            (b"campaign:delete", b"campaign:delete"),
                            (b"transact:send", b"transact:send"),
                            (b"member:read", b"member:read"),
                            (b"member:write", b"member:write"),
                            (b"member:delete", b"member:delete"),
                            (b"maillist:read", b"maillist:read"),
                            (b"maillist:write", b"maillist:write"),
                            (b"maillist:delete", b"maillist:delete"),
                            (b"unsubscribe_list:read", b"unsubscribe_list:read"),
                            (b"unsubscribe_list:write", b"unsubscribe_list:write"),
                            (b"unsubscribe_list:delete", b"unsubscribe_list:delete"),
                        ),
                        default=None,
                    ),
                ),
                (
                    "status",
                    models.PositiveIntegerField(
                        default=0, db_index=True, choices=[(0, "Active"), (1, "Inactive")]
                    ),
                ),
                ("date_added", models.DateTimeField(default=django.utils.timezone.now)),
                ("allowed_origins", models.TextField(null=True, blank=True)),
                ("account", models.ForeignKey(related_name="key_set", to="fan.Account")),
            ],
            options={
                "db_table": "fan_apikey",
            },
        ),
        migrations.CreateModel(
            name="BouncedEmail",
            fields=[
                ("email", models.CharField(max_length=128, serialize=False, primary_key=True)),
                ("count", models.IntegerField(default=0)),
                (
                    "failure_type",
                    models.CharField(
                        max_length=1,
                        choices=[
                            ("T", "Temporary"),
                            ("P", "Permanent"),
                            ("A", "Abuse"),
                            ("F", "Fraud"),
                            ("V", "Virus"),
                            ("O", "Other"),
                            ("N", "Not-spam"),
                        ],
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                ("expire_at", models.DateTimeField()),
            ],
        ),
        migrations.CreateModel(
            name="BounceLog",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("campaign_id", models.IntegerField(null=True)),
                ("email", models.CharField(max_length=128, db_index=True)),
                (
                    "failure_type",
                    models.CharField(
                        max_length=1,
                        choices=[
                            ("T", "Temporary"),
                            ("P", "Permanent"),
                            ("A", "Abuse"),
                            ("F", "Fraud"),
                            ("V", "Virus"),
                            ("O", "Other"),
                            ("N", "Not-spam"),
                        ],
                    ),
                ),
                ("count", models.IntegerField(default=1)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "verbose_name_plural": "Bounce:\u041b\u043e\u0433",
            },
        ),
        migrations.CreateModel(
            name="BounceReceipts",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                (
                    "domain",
                    models.CharField(
                        help_text="\u0414\u043e\u043c\u0435\u043d \u0434\u043b\u044f \u0430\u0434\u0440\u0435\u0441\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430",
                        max_length=128,
                    ),
                ),
                (
                    "email",
                    models.CharField(
                        help_text="\u0410\u0434\u0440\u0435\u0441 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430",
                        max_length=128,
                    ),
                ),
                (
                    "is_virtual",
                    models.BooleanField(
                        default=False,
                        help_text="\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u0442\u044c \u043e\u0442\u0447\u0435\u0442\u044b \u043e \u0434\u043e\u0441\u0442\u0430\u0432\u043a\u0435",
                    ),
                ),
                (
                    "use_in_rrt",
                    models.BooleanField(
                        default=True,
                        help_text="\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0432 Return-path",
                    ),
                ),
                (
                    "imap_host",
                    models.CharField(
                        help_text="IMAP \u0441\u0435\u0440\u0432\u0435\u0440",
                        max_length=256,
                        null=True,
                    ),
                ),
                (
                    "imap_user",
                    models.CharField(
                        help_text="IMAP \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c",
                        max_length=128,
                        null=True,
                    ),
                ),
                ("imap_pwd", models.CharField(max_length=256, null=True)),
            ],
            options={
                "verbose_name": "\u044f\u0449\u0438\u043a \u0434\u043b\u044f \u043e\u0448\u0438\u0431\u043e\u043a \u0434\u043e\u0441\u0442\u0430\u0432\u043a\u0438",
                "verbose_name_plural": "\u042f\u0449\u0438\u043a\u0438 \u0434\u043b\u044f \u043e\u0448\u0438\u0431\u043e\u043a \u0434\u043e\u0441\u0442\u0430\u0432\u043a\u0438",
            },
        ),
        migrations.CreateModel(
            name="Campaign",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                ("api_code", models.CharField(max_length=128, null=True, db_index=True)),
                ("api_key", models.CharField(max_length=128, null=True)),
                (
                    "magic_list_id",
                    models.CharField(
                        max_length=128,
                        null=True,
                        verbose_name="\u041c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u0441\u043b\u043e\u0432\u043e, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0435 \u043f\u043e\u0441\u0442\u043c\u0430\u0441\u0442\u0435\u0440\u0430",
                        blank=True,
                    ),
                ),
                (
                    "type",
                    models.CharField(
                        default="simple",
                        max_length=8,
                        choices=[
                            (
                                "simple",
                                "\u041f\u0440\u043e\u043c\u043e-\u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0430",
                            ),
                            (
                                "AB",
                                "A/B \u043f\u0440\u043e\u043c\u043e-\u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0430",
                            ),
                            (
                                "transact",
                                "\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u043e\u043d\u043d\u043e\u0435 \u043f\u0438\u0441\u044c\u043c\u043e",
                            ),
                            (
                                "transrev",
                                "\u041d\u043e\u0432\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u043e\u043d\u043d\u043e\u0433\u043e \u043f\u0438\u0441\u044c\u043c\u0430",
                            ),
                            (
                                "periodic",
                                "\u041f\u0435\u0440\u0435\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438",
                            ),
                            (
                                "per_chld",
                                "\u0417\u0430\u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u0430\u044f \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0430",
                            ),
                        ],
                    ),
                ),
                (
                    "state",
                    models.CharField(
                        default="draft",
                        max_length=16,
                        choices=[
                            (
                                "embryon",
                                "\u0415\u0449\u0435 \u043d\u0435 \u0441\u043e\u0437\u0434\u0430\u043d\u0430",
                            ),
                            (
                                "draft",
                                "\u041d\u0430 \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438",
                            ),
                            (
                                "onreview",
                                "\u041d\u0430 \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0438",
                            ),
                            ("active", "\u0410\u043a\u0442\u0438\u0432\u043d\u0430"),
                            (
                                "disabled",
                                "\u041e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430",
                            ),
                            (
                                "sending",
                                "\u041d\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435",
                            ),
                            ("done", "\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430"),
                            (
                                "canceling",
                                "\u041e\u0442\u043c\u0435\u043d\u044f\u0435\u0442\u0441\u044f",
                            ),
                            ("canceled", "\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u0430"),
                        ],
                    ),
                ),
                (
                    "description",
                    models.TextField(
                        verbose_name="\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438, \u0434\u043b\u044f \u0441\u0432\u043e\u0438\u0445",
                        blank=True,
                    ),
                ),
                (
                    "testing_emails",
                    fan.db.fields.separatedvaluesfield.SeparatedValuesField(
                        max_length=10240, null=True, blank=True
                    ),
                ),
                ("testing_emails_text", models.CharField(max_length=10240, null=True, blank=True)),
                (
                    "use_utm",
                    models.BooleanField(
                        default=False,
                        help_text="\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c UTM \u0440\u0430\u0437\u043c\u0435\u0442\u043a\u0443 \u0434\u043b\u044f \u043a\u0430\u043c\u043f\u0430\u043d\u0438\u0438",
                    ),
                ),
                (
                    "yandex_metrika",
                    jsonfield.fields.JSONField(
                        default=dict,
                        help_text="\u0421\u0447\u0435\u0442\u0447\u0438\u043a\u0438 \u042f\u043d\u0434\u0435\u043a\u0441.\u041c\u0435\u0442\u0440\u0438\u043a\u0438",
                        null=True,
                        blank=True,
                    ),
                ),
                (
                    "appmetrica",
                    jsonfield.fields.JSONField(
                        default=dict,
                        help_text="\u0421\u043e\u0431\u044b\u0442\u0438\u044f AppMetrica",
                        null=True,
                        blank=True,
                    ),
                ),
                ("deleted", models.BooleanField(default=False)),
                (
                    "created_by",
                    models.CharField(
                        db_index=True, max_length=64, null=True, editable=False, blank=True
                    ),
                ),
                ("submitted_at", models.DateTimeField(null=True, editable=False)),
                (
                    "submitted_by",
                    models.CharField(
                        db_index=True, max_length=64, null=True, editable=False, blank=True
                    ),
                ),
                (
                    "moderation_state",
                    models.CharField(
                        default=None,
                        max_length=16,
                        null=True,
                        blank=True,
                        choices=[
                            (None, "\u041d\u0435 \u0433\u043e\u0442\u043e\u0432\u0430"),
                            (
                                "submitted",
                                "\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0430 \u043d\u0430 \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435",
                            ),
                            (
                                "approved",
                                "\u0423\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0430",
                            ),
                            ("declined", "\u041e\u0442\u043a\u043b\u043e\u043d\u0435\u043d\u0430"),
                        ],
                    ),
                ),
                ("scheduled_for", models.DateTimeField(null=True, blank=True)),
                (
                    "sending_state",
                    models.CharField(
                        default=None,
                        max_length=16,
                        null=True,
                        blank=True,
                        choices=[
                            (
                                None,
                                "\u0415\u0449\u0435 \u043d\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u043b\u0430\u0441\u044c",
                            ),
                            (
                                "sending_ab",
                                "\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e\u0442\u0441\u044f \u0432\u0430\u0440\u0438\u0430\u043d\u0442\u044b \u0410/\u0411",
                            ),
                            (
                                "sent_ab",
                                "\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u044b \u0432\u0430\u0440\u0438\u0430\u043d\u0442\u044b \u0410/\u0411",
                            ),
                            (
                                "sending",
                                "\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u0442\u0441\u044f",
                            ),
                            (
                                "sent",
                                "\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0430",
                            ),
                        ],
                    ),
                ),
                ("sending_state_modified_at", models.DateTimeField(null=True, blank=True)),
                (
                    "sending_control",
                    models.CharField(
                        default=None,
                        max_length=16,
                        null=True,
                        blank=True,
                        choices=[
                            (
                                None,
                                "\u0412\u0441\u0451 \u0438\u0434\u0451\u0442 \u043f\u043e \u043f\u043b\u0430\u043d\u0443",
                            ),
                            ("cancel", "\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u0430"),
                        ],
                    ),
                ),
                (
                    "ab_winner_code",
                    models.CharField(default=None, max_length=4, null=True, blank=True),
                ),
                (
                    "ignore_unsubscribe",
                    models.BooleanField(
                        default=False,
                        help_text="\u0418\u0433\u043d\u043e\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043e\u0442\u043f\u0438\u0441\u043a\u0438",
                        db_column="ignore_global_unsubscribe",
                    ),
                ),
                (
                    "valid_until",
                    models.DateTimeField(
                        help_text="\u041f\u043e\u0441\u043b\u0435 \u044d\u0442\u043e\u0433\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u043d\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0442\u044c \u043f\u0438\u0441\u044c\u043c\u0430",
                        null=True,
                        blank=True,
                    ),
                ),
                ("slug", fan.db.fields.slug.SlugDotField(max_length=192, db_index=False)),
                ("name", models.CharField(default=None, max_length=128, null=True, blank=True)),
                (
                    "scheduling_status",
                    models.CharField(
                        default=None,
                        max_length=16,
                        null=True,
                        choices=[
                            (
                                "waiting",
                                "\u041e\u0436\u0438\u0434\u0430\u0435\u0442 \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f",
                            ),
                            (
                                "in_progress",
                                "\u041f\u043b\u0430\u043d\u0438\u0440\u0443\u0435\u0442\u0441\u044f",
                            ),
                            (
                                "finished",
                                "\u0417\u0430\u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043e",
                            ),
                            (
                                "segments_count",
                                "\u0420\u0430\u0441\u0447\u0435\u0442 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u043e\u0432",
                            ),
                        ],
                    ),
                ),
                (
                    "lawyer_approval_ticket_link",
                    models.CharField(
                        default="",
                        max_length=1024,
                        verbose_name="\u0421\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u0442\u0438\u043a\u0435\u0442 \u0441\u043e\u0433\u043b\u0430\u0441\u043e\u0432\u0430\u043d\u0438\u044f \u0441 \u044e\u0440\u0438\u0441\u0442\u043e\u043c",
                        blank=True,
                    ),
                ),
                (
                    "policy_approval_ticket_link",
                    models.CharField(
                        default="",
                        max_length=1024,
                        verbose_name="\u0421\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u0442\u0438\u043a\u0435\u0442 \u0441\u043e\u0433\u043b\u0430\u0441\u043e\u0432\u0430\u043d\u0438\u044f \u0441 \u043f\u043e\u043b\u0438\u0442\u0438\u043a\u043e\u0439 \u0440\u0430\u0441\u0441\u044b\u043b\u043e\u043a",
                        blank=True,
                    ),
                ),
                (
                    "control_group_percent",
                    models.FloatField(
                        default=0.0,
                        verbose_name="\u041f\u0440\u043e\u0446\u0435\u043d\u0442 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u044b",
                    ),
                ),
                (
                    "data",
                    jsonfield.fields.JSONField(
                        default=dict,
                        help_text="\u0412\u0441\u043f\u043e\u043c\u043e\u0433\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u044b",
                        null=True,
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "\u0420\u0430\u0441\u0441\u044b\u043b\u043a\u0430",
            },
        ),
        migrations.CreateModel(
            name="CampaignABSettings",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                (
                    "variate_what",
                    models.CharField(
                        default="subject",
                        max_length=16,
                        choices=[
                            (
                                "subject",
                                "\u0422\u0435\u043c\u0443 \u043f\u0438\u0441\u044c\u043c\u0430",
                            ),
                            (
                                "body",
                                "\u0421\u043e\u0434\u0435\u0440\u0436\u0430\u043d\u0438\u0435 \u043f\u0438\u0441\u044c\u043c\u0430",
                            ),
                            ("from", "\u041e\u0442 \u043a\u043e\u0433\u043e"),
                        ],
                    ),
                ),
                ("test_percent", models.FloatField(default=10)),
                (
                    "win_strategy",
                    models.CharField(
                        default="manual",
                        max_length=16,
                        choices=[("manual", "\u0412\u0440\u0443\u0447\u043d\u0443\u044e")],
                    ),
                ),
                ("winner_wait_time", models.FloatField(default=None, null=True)),
            ],
        ),
        migrations.CreateModel(
            name="CampaignDeliveryQueueData",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("queue_number", models.PositiveIntegerField(null=True, blank=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
            ],
            options={
                "verbose_name_plural": "\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430:\u041e\u0447\u0435\u0440\u0435\u0434\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u0440\u0430\u0441\u0441\u044b\u043b\u043e\u043a",
            },
        ),
        migrations.CreateModel(
            name="ContentHook",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                ("created_by", models.CharField(max_length=128)),
                ("url", models.TextField()),
                ("name", models.CharField(max_length=255)),
                (
                    "http_method",
                    models.CharField(
                        default="POST", max_length=6, choices=[("GET", "GET"), ("POST", "POST")]
                    ),
                ),
                ("active", models.BooleanField(default=True)),
                ("slug", models.SlugField(max_length=192, db_index=False)),
                ("requests_params", jsonfield.fields.JSONField(null=True)),
                (
                    "account",
                    models.ForeignKey(related_name="contenthook_set", to="fan.Account", null=True),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ContentHookCampaign",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("required", models.BooleanField(default=True)),
            ],
            options={
                "db_table": "fan_contenthook_campaign",
            },
        ),
        migrations.CreateModel(
            name="ContentHookLetter",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("required", models.BooleanField(default=True)),
                ("contenthook", models.ForeignKey(to="fan.ContentHook")),
            ],
            options={
                "db_table": "fan_contenthook_letter",
            },
        ),
        migrations.CreateModel(
            name="DeliveryErrorStats",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                (
                    "status",
                    models.IntegerField(
                        null=True,
                        choices=[
                            (
                                0,
                                "\u041f\u0438\u0441\u044c\u043c\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e",
                            ),
                            (1, "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d email"),
                            (
                                999,
                                "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430",
                            ),
                            (
                                200,
                                "\u0410\u0434\u0440\u0435\u0441 \u043e\u0442\u043f\u0438\u0441\u0430\u043d",
                            ),
                            (
                                201,
                                "\u0410\u0434\u0440\u0435\u0441 \u043d\u0435 \u043f\u0440\u0438\u043d\u0438\u043c\u0430\u0435\u0442 \u043f\u043e\u0447\u0442\u0443 (bounced)",
                            ),
                            (
                                203,
                                "\u0410\u0434\u0440\u0435\u0441 \u043f\u043e\u043f\u0430\u043b \u0432 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u0443\u044e \u0433\u0440\u0443\u043f\u043f\u0443",
                            ),
                            (
                                100,
                                "\u0420\u0430\u0441\u0441\u044b\u043b\u043a\u0430 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430",
                            ),
                            (
                                101,
                                "\u0420\u0430\u0441\u0441\u044b\u043b\u043a\u0430 \u0443\u0441\u0442\u0430\u0440\u0435\u043b\u0430",
                            ),
                            (
                                666,
                                "\u0414\u0443\u0431\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 email",
                            ),
                            (202, "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 email"),
                            (400, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0435\u0442\u0438"),
                            (
                                401,
                                "\u041d\u0435\u0442 \u043c\u0435\u0441\u0442\u0430 \u0432 \u044f\u0449\u0438\u043a\u0435",
                            ),
                            (
                                701,
                                "\u0414\u043e\u043c\u0435\u043d \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044f \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d \u0447\u0435\u0440\u043d\u044b\u043c \u0441\u043f\u0438\u0441\u043a\u043e\u043c",
                            ),
                            (
                                800,
                                "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u043e \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u044f \u0440\u0435\u043d\u0434\u0435\u0440\u0438\u043d\u0433\u0430 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f",
                            ),
                        ],
                    ),
                ),
                ("stat_date", models.DateField(default=None, null=True, blank=True)),
                ("count", models.IntegerField(default=0)),
            ],
        ),
        migrations.CreateModel(
            name="DeliveryLog",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("email", models.CharField(max_length=128)),
                ("status", models.CharField(max_length=16, null=True, blank=True)),
                ("smtp_response", models.CharField(max_length=128, null=True, blank=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "verbose_name_plural": "\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430:\u041b\u043e\u0433",
            },
        ),
        migrations.CreateModel(
            name="DomaninUnsubscribedEmail",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                ("email", models.CharField(max_length=255)),
            ],
            options={
                "verbose_name": "\u0413\u0440\u0443\u043f\u043f\u0430 \u043e\u0442\u043f\u0438\u0441\u043e\u043a: \u043e\u0442\u043f\u0438\u0441\u043a\u0430",
                "verbose_name_plural": "\u0413\u0440\u0443\u043f\u043f\u044b \u043e\u0442\u043f\u0438\u0441\u043e\u043a: \u043e\u0442\u043f\u0438\u0441\u043a\u0438",
            },
        ),
        migrations.CreateModel(
            name="EditorialLog",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("object_type", models.CharField(max_length=128)),
                ("object_id", models.CharField(max_length=128)),
                ("component", models.CharField(max_length=128, null=True)),
                ("action", models.CharField(max_length=128, null=True)),
                ("description", models.TextField(null=True)),
                ("metadata", models.TextField(null=True)),
                ("user", models.CharField(max_length=128)),
                ("datetime", models.DateTimeField(auto_now=True)),
                ("user_ip", models.CharField(max_length=128)),
                ("user_agent", models.CharField(max_length=255, null=True)),
                (
                    "file",
                    models.FileField(max_length=250, null=True, upload_to=b"uploads/%Y/%m/%d/"),
                ),
            ],
        ),
        migrations.CreateModel(
            name="EmailRestriction",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                ("email", models.CharField(unique=True, max_length=128)),
                (
                    "accounts",
                    models.ManyToManyField(
                        related_name="email_restrictions",
                        verbose_name="\u0410\u043a\u043a\u0430\u0443\u043d\u0442\u044b",
                        to="fan.Account",
                    ),
                ),
            ],
            options={
                "verbose_name": "\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u0435\u043b\u044f",
                "verbose_name_plural": "\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f \u043d\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u0435\u043b\u044f",
            },
        ),
        migrations.CreateModel(
            name="EventHook",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                ("created_by", models.CharField(max_length=128)),
                ("url", models.TextField()),
                ("name", models.CharField(max_length=255)),
                (
                    "http_method",
                    models.CharField(
                        default="POST", max_length=6, choices=[("GET", "GET"), ("POST", "POST")]
                    ),
                ),
                ("active", models.BooleanField(default=True)),
                ("slug", models.SlugField(max_length=192, db_index=False)),
                ("requests_params", jsonfield.fields.JSONField(null=True)),
                (
                    "on",
                    jsonfield.fields.JSONField(
                        default=dict,
                        help_text="\u041f\u0440\u0438 \u043a\u0430\u043a\u0438\u0445 \u0441\u043e\u0431\u044b\u0442\u0438\u044f\u0445 \u0432\u044b\u0437\u044b\u0432\u0430\u0442\u044c \u044d\u0442\u043e\u0442 \u0445\u0443\u043a",
                    ),
                ),
                (
                    "account",
                    models.ForeignKey(related_name="eventhook_set", to="fan.Account", null=True),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="GlobalBlackList",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                (
                    "domain",
                    models.CharField(
                        help_text="\u0414\u043e\u043c\u0435\u043d \u043f\u043e\u0447\u0442\u043e\u0432\u043e\u0433\u043e \u044f\u0449\u0438\u043a\u0430",
                        unique=True,
                        max_length=256,
                    ),
                ),
                (
                    "active",
                    models.BooleanField(
                        default=True,
                        help_text="\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0444\u0438\u043b\u044c\u0442\u0440\u0430\u0446\u0438\u044e",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        help_text="\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f",
                        auto_now_add=True,
                    ),
                ),
                (
                    "modified_at",
                    models.DateTimeField(
                        help_text="\u0414\u0430\u0442\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u043c\u043e\u0434\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438",
                        auto_now=True,
                    ),
                ),
            ],
            options={
                "verbose_name": "\u0427\u0435\u0440\u043d\u044b\u0439 \u0441\u043f\u0438\u0441\u043e\u043a",
                "verbose_name_plural": "\u0427\u0435\u0440\u043d\u044b\u0439 \u0441\u043f\u0438\u0441\u043e\u043a",
            },
        ),
        migrations.CreateModel(
            name="Letter",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                (
                    "state",
                    models.CharField(
                        default="draft",
                        max_length=16,
                        choices=[
                            (
                                "draft",
                                "\u041d\u0430 \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438",
                            ),
                            (
                                "onreview",
                                "\u041d\u0430 \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0438",
                            ),
                            ("active", "\u0410\u043a\u0442\u0438\u0432\u043d\u0430"),
                            (
                                "disabled",
                                "\u041e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430",
                            ),
                        ],
                    ),
                ),
                (
                    "revision",
                    models.IntegerField(
                        default=0,
                        verbose_name="\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u043f\u0438\u0441\u044c\u043c\u0430, \u0443\u0432\u0435\u043b\u0438\u0447\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u043f\u0440\u0438 \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438",
                    ),
                ),
                (
                    "code",
                    models.CharField(
                        default="A",
                        max_length=16,
                        verbose_name="\u041d\u043e\u043c\u0435\u0440 \u043f\u0438\u0441\u044c\u043c\u0430 \u0432\u043d\u0443\u0442\u0440\u0438 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438",
                    ),
                ),
                (
                    "description",
                    models.TextField(
                        verbose_name="\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043f\u0438\u0441\u044c\u043c\u0430, \u0434\u043b\u044f \u0441\u0432\u043e\u0438\u0445",
                        blank=True,
                    ),
                ),
                (
                    "template_engine",
                    models.CharField(
                        max_length=32,
                        null=True,
                        verbose_name="\u042f\u0437\u044b\u043a \u0442\u0435\u043c\u043f\u043b\u0435\u0439\u0442\u0430",
                    ),
                ),
                (
                    "subject",
                    models.CharField(
                        max_length=1024,
                        verbose_name="\u0422\u0435\u043c\u0430 \u043f\u0438\u0441\u044c\u043c\u0430",
                    ),
                ),
                ("from_name", models.CharField(max_length=384)),
                ("from_email", models.CharField(max_length=384)),
                ("reply_to", models.CharField(max_length=128)),
                ("charset", models.CharField(default="utf-8", max_length=32)),
                ("html_body", models.TextField()),
                ("text_body", models.TextField()),
                ("use_text_body", models.BooleanField(default=False)),
                ("link_stats_used", models.BooleanField(default=False)),
                ("pixel_stats_used", models.BooleanField(default=False)),
                ("utm_marks_used", models.BooleanField(default=False)),
                ("allowed_links", jsonfield.fields.JSONField(null=True)),
                ("allowed_domains", jsonfield.fields.JSONField(null=True)),
                ("template_meta", jsonfield.fields.JSONField(null=True)),
                ("published", models.BooleanField(default=False)),
            ],
            options={
                "verbose_name_plural": "\u041f\u0438\u0441\u044c\u043c\u043e",
            },
        ),
        migrations.CreateModel(
            name="LetterAttachment",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("filename", models.CharField(max_length=1024, blank=True)),
                ("uri", models.CharField(max_length=1024, null=True)),
                ("mime_type", models.CharField(max_length=128, null=True)),
                ("subtype", models.CharField(max_length=128, null=True)),
                ("db_data", models.BinaryField(null=True, db_column="data")),
                (
                    "store_data",
                    models.FileField(
                        storage=storages.backends.s3boto3.S3Boto3Storage(
                            location="shared_files", file_overwrite=True
                        ),
                        null=True,
                        upload_to=fan.models.letter.attachment_get_file_name,
                    ),
                ),
                ("is_inline", models.BooleanField(default=False)),
                ("is_shared", models.BooleanField(default=False)),
                ("source_url", models.CharField(max_length=1024, blank=True)),
                ("publish_path", models.CharField(max_length=128, null=True, blank=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "verbose_name_plural": "\u041f\u0438\u0441\u044c\u043c\u043e:\u0432\u043b\u043e\u0436\u0435\u043d\u0438\u0435",
            },
        ),
        migrations.CreateModel(
            name="MailList",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                ("api_code", models.CharField(max_length=128, null=True, db_index=True)),
                ("api_key", models.CharField(max_length=128, null=True)),
                ("title", models.CharField(max_length=255)),
                (
                    "description",
                    models.TextField(
                        verbose_name="\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0441\u043f\u0438\u0441\u043a\u0430 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438",
                        blank=True,
                    ),
                ),
                (
                    "fields_descr",
                    django.contrib.postgres.fields.hstore.HStoreField(
                        null=True,
                        verbose_name="\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u043f\u043e\u043b\u0435\u0439",
                    ),
                ),
                (
                    "subscribers_number",
                    models.IntegerField(
                        null=True,
                        verbose_name="\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u043f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u043e\u0432 (\u043a\u044d\u0448)",
                    ),
                ),
                (
                    "inactive_subscribers_number",
                    models.IntegerField(
                        null=True,
                        verbose_name="\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043d\u0435\u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u043f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u043e\u0432 (\u043a\u044d\u0448)",
                    ),
                ),
                ("subscribers_number_calculated_at", models.DateTimeField(null=True)),
                ("deleted", models.BooleanField(default=False)),
                (
                    "created_by",
                    models.CharField(max_length=64, null=True, editable=False, blank=True),
                ),
                ("url_after_unsubscribe", models.CharField(max_length=765)),
                ("slug", models.SlugField(max_length=192, db_index=False)),
                ("data_fields", jsonfield.fields.JSONField(null=True, blank=True)),
                ("account", models.ForeignKey(related_name="list_set", to="fan.Account")),
            ],
            options={
                "verbose_name_plural": "\u0421\u043f\u0438\u0441\u043e\u043a \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438",
            },
        ),
        migrations.CreateModel(
            name="MailListElement",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                ("email", models.CharField(max_length=255)),
                ("name", models.CharField(max_length=255, null=True)),
                (
                    "legacy_data",
                    django.contrib.postgres.fields.hstore.HStoreField(
                        null=True,
                        verbose_name="\u041b\u044e\u0431\u044b\u0435 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0432 json",
                        db_column="data",
                    ),
                ),
                (
                    "json_data",
                    jsonfield.fields.JSONField(
                        null=True,
                        verbose_name="\u041b\u044e\u0431\u044b\u0435 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0432 json",
                        blank=True,
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        default="",
                        max_length=12,
                        choices=[
                            ("", "\u041f\u043e\u0434\u043f\u0438\u0441\u0430\u043d"),
                            ("unsub", "\u041e\u0442\u043f\u0438\u0441\u0430\u043d"),
                            (
                                "bnc",
                                "\u041e\u0448\u0438\u0431\u043a\u0438 \u0434\u043e\u0441\u0442\u0430\u0432\u043a\u0438",
                            ),
                            ("dsbl", "\u041e\u0442\u043a\u043b\u044e\u0447\u0435\u043d"),
                        ],
                    ),
                ),
                ("enabled", models.BooleanField(default=True)),
                ("deleted", models.BooleanField(default=False)),
                ("rev", models.BigIntegerField(null=True)),
                ("list", models.ForeignKey(related_name="elements", to="fan.MailList")),
            ],
            options={
                "verbose_name_plural": "\u0421\u043f\u0438\u0441\u043e\u043a:\u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b",
            },
        ),
        migrations.CreateModel(
            name="MailWidget",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("is_active", models.BooleanField(default=True)),
                ("label", models.SlugField(max_length=64, null=True, blank=True)),
                ("letter_code", models.CharField(default=b"A", max_length=16)),
                ("headers", models.TextField()),
            ],
            options={
                "db_table": "fan_mailwidgets",
            },
        ),
        migrations.CreateModel(
            name="MonitoringCampaign",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                (
                    "schedule_run_at",
                    models.DateTimeField(
                        null=True,
                        verbose_name="\u0414\u0430\u0442\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f",
                    ),
                ),
                (
                    "schedule_task_mark",
                    models.CharField(
                        max_length=1024,
                        null=True,
                        verbose_name="\u041c\u0435\u0442\u043a\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u043d\u0435\u043e\u0442\u043c\u0435\u043d\u0435\u043d\u043d\u043e\u0439 \u0437\u0430\u0434\u0430\u0447\u0438 \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f",
                    ),
                ),
                (
                    "schedule_cancel_created_at",
                    models.DateTimeField(
                        null=True,
                        verbose_name="\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0437\u0430\u0434\u0430\u0447\u0438 \u0440\u0430\u0441\u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f",
                    ),
                ),
                (
                    "last_send_at",
                    models.DateTimeField(
                        null=True,
                        verbose_name="\u0414\u0430\u0442\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Option",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("object_id", models.PositiveIntegerField()),
                (
                    "key",
                    models.CharField(
                        max_length=64,
                        choices=[
                            (
                                "subscribe_link",
                                "\u0410\u0434\u0440\u0435\u0441 \u0440\u0435\u0434\u0438\u0440\u0435\u043a\u0442\u0430 \u043f\u043e\u0441\u043b\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438",
                            ),
                            (
                                "unsubscribe_link",
                                "\u0410\u0434\u0440\u0435\u0441 \u0440\u0435\u0434\u0438\u0440\u0435\u043a\u0442\u0430 \u043f\u043e\u0441\u043b\u0435 \u043e\u0442\u043f\u0438\u0441\u043a\u0438",
                            ),
                            (
                                "transaction_subs_campaign",
                                "\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u043e\u043d\u043d\u043e\u0435 \u043f\u0438\u0441\u044c\u043c\u043e \u0434\u043b\u044f \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438",
                            ),
                            (
                                "utm_source",
                                "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u043b\u044f utm_source \u043f\u0440\u0438 \u0440\u0430\u0437\u043c\u0435\u0442\u043a\u0435 \u0441\u0441\u044b\u043b\u043e\u043a",
                            ),
                            (
                                "yt_token",
                                "OAuth \u0442\u043e\u043a\u0435\u043d \u0434\u043b\u044f \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a YT",
                            ),
                            (
                                "use_accessor_moderation",
                                "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043c\u043e\u0434\u0435\u0440\u0430\u0446\u0438\u044e \u0447\u0435\u0440\u0435\u0437 \u0430\u0441\u0435\u0441\u0441\u043e\u0440\u043e\u0432",
                            ),
                        ],
                    ),
                ),
                ("value", fan.db.fields.pickle.UnicodePickledObjectField(editable=False)),
                ("content_type", models.ForeignKey(to="contenttypes.ContentType")),
            ],
            options={
                "verbose_name": "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438",
                "verbose_name_plural": "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438",
            },
        ),
        migrations.CreateModel(
            name="PermittedTestingEmails",
            fields=[
                ("email", models.CharField(max_length=128, serialize=False, primary_key=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "verbose_name_plural": "\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430:TestingWhitelist",
            },
        ),
        migrations.CreateModel(
            name="ProcessingFile",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                ("created_by", models.CharField(max_length=128)),
                (
                    "data",
                    models.BinaryField(
                        verbose_name="\u0442\u0435\u043b\u043e \u0444\u0430\u0439\u043b\u0430 \u0441\u043e \u0441\u043f\u0438\u0441\u043a\u043e\u043c"
                    ),
                ),
                ("data_encoding", models.CharField(max_length=32, null=True)),
                (
                    "filename",
                    models.CharField(
                        max_length=255,
                        null=True,
                        verbose_name="\u0438\u043c\u044f \u0444\u0430\u0439\u043b\u0430",
                    ),
                ),
                (
                    "process_started_at",
                    models.DateTimeField(default=None, null=True, editable=False),
                ),
                (
                    "task_id",
                    models.CharField(
                        max_length=128,
                        null=True,
                        verbose_name="id \u0430\u0441\u0438\u043d\u0445\u0440\u043e\u043d\u043d\u043e\u0439 \u0437\u0430\u0434\u0430\u0447\u0438",
                    ),
                ),
                ("total_count", models.IntegerField(null=True)),
                ("processed_count", models.IntegerField(null=True)),
                (
                    "state",
                    models.CharField(
                        max_length=12,
                        null=True,
                        choices=[
                            ("", ""),
                            (
                                "inprogress",
                                "\u043e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0435\u0442\u0441\u044f",
                            ),
                            (
                                "finished",
                                "\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430",
                            ),
                        ],
                    ),
                ),
                ("object_id", models.PositiveIntegerField()),
                (
                    "file_type",
                    models.PositiveIntegerField(
                        choices=[
                            (1, b"maillist_upload"),
                            (2, b"maillist_unsubscribe"),
                            (3, b"maillist_download"),
                            (4, b"unsubscribe_upload"),
                            (5, b"unsubscribe_download"),
                            (6, b"unsubscribe_remove"),
                            (7, b"campaign_scheduling_errors"),
                            (8, b"campaign_delivery_errors"),
                            (9, b"campaign_sent_emails"),
                            (10, b"campaign_opened_letter"),
                            (11, b"campaign_opened_links"),
                            (12, b"campaign_unsubscribed"),
                            (13, b"campaign_bounced_emails"),
                            (14, b"campaign_stats"),
                            (15, b"single_use_maillist_errors"),
                            (16, b"maillist_upload_errors"),
                            (17, b"datatable_generator_upload"),
                            (18, b"datatable_generator_download"),
                            (19, b"datatable_table_upload"),
                            (20, b"datatable_table_delete"),
                            (21, b"datatable_table_download"),
                            (22, b"campaign_control_group"),
                        ]
                    ),
                ),
                ("extras", jsonfield.fields.JSONField(null=True)),
                (
                    "content_type",
                    models.ForeignKey(related_name="content_type", to="contenttypes.ContentType"),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ProcessLocks",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("process_name", models.CharField(max_length=256)),
                ("hostname", models.CharField(max_length=256)),
                ("params", jsonfield.fields.JSONField(null=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "verbose_name_plural": "\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430:\u041b\u043e\u043a \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u043e\u0432",
            },
        ),
        migrations.CreateModel(
            name="Project",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                ("created_by", models.CharField(max_length=128)),
                ("slug", models.SlugField(max_length=192, db_index=False)),
                ("title", models.CharField(max_length=384)),
                ("default_from_name", models.CharField(max_length=384, null=True, blank=True)),
                ("default_from_email", models.CharField(max_length=384, null=True, blank=True)),
                (
                    "default_testing_emails",
                    fan.db.fields.separatedvaluesfield.SeparatedValuesField(
                        max_length=1024, null=True, blank=True
                    ),
                ),
                ("deleted", models.BooleanField(default=False)),
                ("account", models.ForeignKey(related_name="project_set", to="fan.Account")),
            ],
            options={
                "verbose_name_plural": "\u041f\u0440\u043e\u0435\u043a\u0442",
            },
        ),
        migrations.CreateModel(
            name="ProjectKey",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("label", models.SlugField(max_length=64, null=True, blank=True)),
                ("public_key", models.CharField(max_length=32, unique=True, null=True)),
                ("secret_key", models.CharField(max_length=32, unique=True, null=True)),
                (
                    "roles",
                    bitfield.models.BitField((("transact", "Transact API access"),), default=1),
                ),
                (
                    "status",
                    models.PositiveIntegerField(
                        default=0, db_index=True, choices=[(0, "Active"), (1, "Inactive")]
                    ),
                ),
                ("date_added", models.DateTimeField(default=django.utils.timezone.now, null=True)),
                ("project", models.ForeignKey(related_name="key_set", to="fan.Project")),
            ],
            options={
                "db_table": "fan_projectkey",
            },
        ),
        migrations.CreateModel(
            name="SendBatch",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                (
                    "status",
                    models.CharField(
                        default="new",
                        max_length=16,
                        choices=[
                            ("new", "new"),
                            ("sending", "sending"),
                            ("retry", "retry"),
                            ("error", "error"),
                            ("canceled", "canceled"),
                            ("sent", "sent"),
                        ],
                    ),
                ),
                ("status_modified_at", models.DateTimeField(null=True, blank=True)),
                ("send_count", models.PositiveIntegerField(null=True, blank=True)),
                ("sent_at", models.DateTimeField(null=True)),
                ("recipient_states", jsonfield.fields.JSONField(null=True)),
                ("data", models.BinaryField()),
                (
                    "data_encoding",
                    models.CharField(default="gzip", max_length=16, choices=[("gzip", "gzip")]),
                ),
                ("dry_run", models.BooleanField(default=False)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SingleUseMailList",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                ("description", models.TextField(blank=True)),
                ("data", models.BinaryField()),
                ("data_preview", models.TextField()),
                ("data_preview_json", models.TextField(null=True, blank=True)),
                (
                    "data_encoding",
                    models.CharField(default="gzip", max_length=16, choices=[("gzip", "gzip")]),
                ),
                ("uploaded_at", models.DateTimeField(null=True)),
                ("uploaded_by", models.CharField(max_length=128)),
                ("subscribers_number", models.IntegerField(null=True)),
                ("subscribers_number_calculated_at", models.DateTimeField(null=True)),
                ("data_fields", jsonfield.fields.JSONField(null=True, blank=True)),
            ],
            options={
                "verbose_name_plural": "\u041e\u0434\u043d\u043e\u0440\u0430\u0437\u043e\u0432\u044b\u0439 \u0441\u043f\u0438\u0441\u043e\u043a \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438",
            },
        ),
        migrations.CreateModel(
            name="StatAction",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("letter_id", models.IntegerField()),
                ("campaign_id", models.IntegerField()),
                ("email", models.CharField(max_length=255)),
                ("user_ip", models.CharField(max_length=255)),
                ("user_agent", models.CharField(max_length=512, null=True)),
                ("action", models.CharField(max_length=255)),
                ("link_number", models.IntegerField(null=True)),
                (
                    "hits",
                    models.BigIntegerField(
                        default=1,
                        verbose_name="\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0445\u0438\u0442\u043e\u0432",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True, null=True)),
            ],
            options={
                "verbose_name_plural": "\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439",
            },
        ),
        migrations.CreateModel(
            name="StatsCampaign",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                (
                    "stat_date",
                    models.DateField(
                        default=None,
                        null=True,
                        verbose_name="\u0414\u0430\u0442\u0430 \u0441\u0447\u0435\u0442\u0447\u0438\u043a\u0430",
                        blank=True,
                    ),
                ),
                (
                    "messages_processed",
                    models.IntegerField(
                        default=0,
                        verbose_name="\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e",
                    ),
                ),
                (
                    "messages_delivered",
                    models.IntegerField(
                        default=0,
                        verbose_name="\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e",
                    ),
                ),
                (
                    "messages_not_delivered",
                    models.IntegerField(
                        default=0,
                        verbose_name="\u041d\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e",
                    ),
                ),
                (
                    "control_group_count",
                    models.IntegerField(
                        default=0,
                        verbose_name="\u0410\u0434\u0440\u0435\u0441\u0430\u0442\u043e\u0432 \u0432 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u0435",
                    ),
                ),
                (
                    "reads",
                    models.IntegerField(
                        default=None,
                        null=True,
                        verbose_name="\u0422\u043e\u0447\u043d\u043e \u043e\u0442\u043a\u0440\u044b\u043b\u0438",
                        blank=True,
                    ),
                ),
                (
                    "opens",
                    models.IntegerField(
                        default=None,
                        null=True,
                        verbose_name="\u041e\u0442\u043a\u0440\u044b\u0442\u0438\u044f",
                        blank=True,
                    ),
                ),
                (
                    "clicks",
                    models.IntegerField(
                        default=None,
                        null=True,
                        verbose_name="\u041a\u043b\u0438\u043a\u0438",
                        blank=True,
                    ),
                ),
                (
                    "clicks_unique",
                    models.IntegerField(
                        default=None,
                        null=True,
                        verbose_name="\u041a\u043b\u0438\u043a\u043d\u0443\u0432\u0448\u0438\u0435",
                        blank=True,
                    ),
                ),
                (
                    "deletes",
                    models.IntegerField(
                        default=None,
                        null=True,
                        verbose_name="\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u044f",
                        blank=True,
                    ),
                ),
                (
                    "spam",
                    models.IntegerField(
                        default=None, null=True, verbose_name="\u0421\u043f\u0430\u043c", blank=True
                    ),
                ),
                (
                    "unsubscribes",
                    models.IntegerField(
                        default=None,
                        null=True,
                        verbose_name="\u041e\u0442\u043f\u0438\u0441\u0430\u043b\u0438\u0441\u044c",
                        blank=True,
                    ),
                ),
                (
                    "unsubscribes_global",
                    models.IntegerField(
                        default=None,
                        null=True,
                        verbose_name="\u041e\u0442\u043f\u0438\u0441\u0430\u043b\u0438\u0441\u044c",
                        blank=True,
                    ),
                ),
                (
                    "bounces",
                    models.IntegerField(
                        default=None,
                        null=True,
                        verbose_name="\u041f\u0438\u0441\u0435\u043c \u0432\u0435\u0440\u043d\u0443\u043b\u043e\u0441\u044c",
                        blank=True,
                    ),
                ),
                ("bounces_permanent", models.IntegerField(default=None, null=True, blank=True)),
                ("bounces_temporary", models.IntegerField(default=None, null=True, blank=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "verbose_name_plural": "\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u043f\u043e \u043a\u0430\u043c\u043f\u0430\u043d\u0438\u0438",
            },
        ),
        migrations.CreateModel(
            name="StatsLetter",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                (
                    "stat_date",
                    models.DateField(
                        default=None,
                        null=True,
                        verbose_name="\u0414\u0430\u0442\u0430 \u0441\u0447\u0435\u0442\u0447\u0438\u043a\u0430",
                        blank=True,
                    ),
                ),
                (
                    "messages_processed",
                    models.IntegerField(
                        default=0,
                        verbose_name="\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e",
                    ),
                ),
                (
                    "messages_delivered",
                    models.IntegerField(
                        default=0,
                        verbose_name="\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e",
                    ),
                ),
                (
                    "messages_not_delivered",
                    models.IntegerField(
                        default=0,
                        verbose_name="\u041d\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e",
                    ),
                ),
                (
                    "control_group_count",
                    models.IntegerField(
                        default=0,
                        verbose_name="\u0410\u0434\u0440\u0435\u0441\u0430\u0442\u043e\u0432 \u0432 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u0435",
                    ),
                ),
                (
                    "reads",
                    models.IntegerField(
                        default=None,
                        null=True,
                        verbose_name="\u0422\u043e\u0447\u043d\u043e \u043e\u0442\u043a\u0440\u044b\u043b\u0438",
                        blank=True,
                    ),
                ),
                (
                    "opens",
                    models.IntegerField(
                        default=None,
                        null=True,
                        verbose_name="\u041e\u0442\u043a\u0440\u044b\u0442\u0438\u044f",
                        blank=True,
                    ),
                ),
                (
                    "clicks",
                    models.IntegerField(
                        default=None,
                        null=True,
                        verbose_name="\u041a\u043b\u0438\u043a\u0438",
                        blank=True,
                    ),
                ),
                (
                    "clicks_unique",
                    models.IntegerField(
                        default=None,
                        null=True,
                        verbose_name="\u041a\u043b\u0438\u043a\u043d\u0443\u0432\u0448\u0438\u0435",
                        blank=True,
                    ),
                ),
                (
                    "deletes",
                    models.IntegerField(
                        default=None,
                        null=True,
                        verbose_name="\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u044f",
                        blank=True,
                    ),
                ),
                (
                    "spam",
                    models.IntegerField(
                        default=None, null=True, verbose_name="\u0421\u043f\u0430\u043c", blank=True
                    ),
                ),
                (
                    "unsubscribes",
                    models.IntegerField(
                        default=None,
                        null=True,
                        verbose_name="\u041e\u0442\u043f\u0438\u0441\u0430\u043b\u0438\u0441\u044c",
                        blank=True,
                    ),
                ),
                (
                    "unsubscribes_global",
                    models.IntegerField(
                        default=None,
                        null=True,
                        verbose_name="\u041e\u0442\u043f\u0438\u0441\u0430\u043b\u0438\u0441\u044c",
                        blank=True,
                    ),
                ),
                (
                    "bounces",
                    models.IntegerField(
                        default=None,
                        null=True,
                        verbose_name="\u041f\u0438\u0441\u0435\u043c \u0432\u0435\u0440\u043d\u0443\u043b\u043e\u0441\u044c",
                        blank=True,
                    ),
                ),
                ("bounces_permanent", models.IntegerField(default=None, null=True, blank=True)),
                ("bounces_temporary", models.IntegerField(default=None, null=True, blank=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                (
                    "source",
                    models.CharField(
                        max_length=128,
                        choices=[("postoffice", "postoffice.yandex.ru"), ("fan", "fan")],
                    ),
                ),
                (
                    "is_final",
                    models.BooleanField(
                        default=False,
                        verbose_name="\u041f\u043e\u043b\u043d\u043e\u0441\u0442\u044c\u044e \u043f\u0435\u0440\u0435\u0441\u0447\u0438\u0442\u0430\u043d\u0430",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u043f\u043e \u043f\u0438\u0441\u044c\u043c\u0443",
            },
        ),
        migrations.CreateModel(
            name="StatsLink",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                (
                    "stat_date",
                    models.DateField(
                        default=None,
                        null=True,
                        verbose_name="\u0414\u0430\u0442\u0430 \u0441\u0447\u0435\u0442\u0447\u0438\u043a\u0430",
                        blank=True,
                    ),
                ),
                (
                    "link_number",
                    models.CharField(default=None, max_length=255, null=True, blank=True),
                ),
                ("clicks", models.IntegerField(default=None, null=True, blank=True)),
                ("clicks_unique", models.IntegerField(default=None, null=True, blank=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "verbose_name_plural": "\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u043f\u043e \u0441\u0441\u044b\u043b\u043a\u0430\u043c",
            },
        ),
        migrations.CreateModel(
            name="StatusLog",
            fields=[
                ("msg_id", models.TextField(serialize=False, primary_key=True)),
                ("code", models.IntegerField()),
                ("text", models.CharField(max_length=256, blank=True)),
                ("retry", models.BooleanField(default=False)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("expire_at", models.DateTimeField(editable=False, db_index=True)),
            ],
        ),
        migrations.CreateModel(
            name="Tag",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("title", models.CharField(max_length=255)),
                ("is_system", models.BooleanField(default=False)),
                ("account", models.ForeignKey(related_name="tags", to="fan.Account")),
            ],
            options={
                "verbose_name": "\u0422\u0435\u0433",
                "verbose_name_plural": "\u0422\u0435\u0433\u0438",
            },
        ),
        migrations.CreateModel(
            name="TvmService",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("label", models.SlugField(max_length=64, null=True, blank=True)),
                ("source", models.PositiveIntegerField(default=0, db_index=True)),
                (
                    "status",
                    models.PositiveIntegerField(
                        default=0, db_index=True, choices=[(0, "Active"), (1, "Inactive")]
                    ),
                ),
                ("date_added", models.DateTimeField(default=django.utils.timezone.now, null=True)),
                (
                    "scopes",
                    bitfield.models.BitField(
                        (
                            (b"project:read", b"project:read"),
                            (b"project:write", b"project:write"),
                            (b"project:delete", b"project:delete"),
                            (b"account:read", b"account:read"),
                            (b"account:write", b"account:write"),
                            (b"account:delete", b"account:delete"),
                            (b"campaign:read", b"campaign:read"),
                            (b"campaign:write", b"campaign:write"),
                            (b"campaign:delete", b"campaign:delete"),
                            (b"transact:send", b"transact:send"),
                            (b"member:read", b"member:read"),
                            (b"member:write", b"member:write"),
                            (b"member:delete", b"member:delete"),
                            (b"maillist:read", b"maillist:read"),
                            (b"maillist:write", b"maillist:write"),
                            (b"maillist:delete", b"maillist:delete"),
                            (b"unsubscribe_list:read", b"unsubscribe_list:read"),
                            (b"unsubscribe_list:write", b"unsubscribe_list:write"),
                            (b"unsubscribe_list:delete", b"unsubscribe_list:delete"),
                        ),
                        default=None,
                    ),
                ),
                ("account", models.ForeignKey(related_name="tvmservice_set", to="fan.Account")),
            ],
            options={
                "db_table": "fan_tvmservice",
            },
        ),
        migrations.CreateModel(
            name="UnsubscribeDomain",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        max_length=255,
                        verbose_name="\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435",
                    ),
                ),
                ("slug", models.SlugField(max_length=192, db_index=False)),
                (
                    "accounts",
                    models.ManyToManyField(
                        related_name="unsub_domains",
                        verbose_name="\u0410\u043a\u043a\u0430\u0443\u043d\u0442\u044b",
                        to="fan.Account",
                    ),
                ),
            ],
            options={
                "verbose_name": "\u0413\u0440\u0443\u043f\u043f\u0430 \u043e\u0442\u043f\u0438\u0441\u043e\u043a",
                "verbose_name_plural": "\u0413\u0440\u0443\u043f\u043f\u044b \u043e\u0442\u043f\u0438\u0441\u043e\u043a",
            },
        ),
        migrations.CreateModel(
            name="UnsubscribeListElement",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                ("email", models.CharField(max_length=255)),
                (
                    "list",
                    models.ForeignKey(
                        related_name="elements",
                        verbose_name="\u0421\u043f\u0438\u0441\u043e\u043a \u043e\u0442\u043f\u0438\u0441\u043a\u0438",
                        to="fan.AccountUnsubscribeList",
                    ),
                ),
            ],
            options={
                "verbose_name": "\u0421\u043f\u0438\u0441\u043e\u043a \u043e\u0442\u043f\u0438\u0441\u043a\u0438: \u043e\u0442\u043f\u0438\u0441\u043a\u0430",
                "verbose_name_plural": "\u0421\u043f\u0438\u0441\u043a\u0438 \u043e\u0442\u043f\u0438\u0441\u043a\u0438: \u043e\u0442\u043f\u0438\u0441\u043a\u0438",
            },
        ),
        migrations.CreateModel(
            name="UnsubscribeLog",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("campaign_id", models.IntegerField(null=True)),
                ("letter_id", models.IntegerField(null=True, db_index=True)),
                ("email", models.CharField(max_length=128)),
                ("reason", models.CharField(max_length=255, null=True, blank=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "verbose_name_plural": "Unsubscribe:\u041b\u043e\u0433",
            },
        ),
        migrations.CreateModel(
            name="UnsubscribeRedirect",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                ("created_by", models.CharField(max_length=128)),
                ("url", models.TextField()),
                ("name", models.CharField(max_length=255)),
                (
                    "http_method",
                    models.CharField(
                        default="POST", max_length=6, choices=[("GET", "GET"), ("POST", "POST")]
                    ),
                ),
                ("active", models.BooleanField(default=True)),
                ("slug", models.SlugField(max_length=192, db_index=False)),
                (
                    "account",
                    models.ForeignKey(
                        related_name="unsubscriberedirect_set", to="fan.Account", null=True
                    ),
                ),
                (
                    "project",
                    models.ForeignKey(
                        related_name="unsubscriberedirect_set", to="fan.Project", null=True
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="UserRole",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID", serialize=False, auto_created=True, primary_key=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                ("user_id", models.CharField(max_length=256, db_index=True)),
                (
                    "role",
                    models.CharField(
                        max_length=64,
                        choices=[
                            ("user", "user"),
                            ("moderator", "moderator"),
                            ("assessor_tester", "assessor_tester"),
                            ("assessor_moderator", "assessor_moderator"),
                        ],
                    ),
                ),
                (
                    "account",
                    models.ForeignKey(
                        related_name="roles", db_constraint=False, to="fan.Account", null=True
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="YandexService",
            fields=[
                ("label", models.CharField(max_length=128, serialize=False, primary_key=True)),
                ("title", models.CharField(max_length=128)),
            ],
        ),
        migrations.CreateModel(
            name="LetterUtm",
            fields=[
                (
                    "letter",
                    models.OneToOneField(
                        related_name="utm", primary_key=True, serialize=False, to="fan.Letter"
                    ),
                ),
                ("utm_source", models.CharField(max_length=256, blank=True)),
                ("utm_medium", models.CharField(max_length=256, blank=True)),
                ("utm_campaign", models.CharField(max_length=256, blank=True)),
                ("utm_content", models.CharField(max_length=256, blank=True)),
            ],
            options={
                "verbose_name": "\u041f\u0438\u0441\u044c\u043c\u043e:Utm",
                "verbose_name_plural": "\u041f\u0438\u0441\u044c\u043c\u043e:Utm",
            },
        ),
        migrations.CreateModel(
            name="PeriodicCampaign",
            fields=[
                (
                    "campaign",
                    models.OneToOneField(
                        related_name="periodic_campaign",
                        primary_key=True,
                        serialize=False,
                        to="fan.Campaign",
                    ),
                ),
                ("crontab", models.CharField(max_length=255, null=True, blank=True)),
                ("next_date", models.DateTimeField(null=True, blank=True)),
                ("exclude_rules", jsonfield.fields.JSONField(null=True)),
                ("start_date", models.DateTimeField(default=django.utils.timezone.now)),
                ("end_date", models.DateTimeField()),
            ],
            options={
                "verbose_name": "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u0435\u0440\u0435\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u043e\u0439 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438",
                "verbose_name_plural": "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u0435\u0440\u0435\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u043e\u0439 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438",
            },
        ),
        migrations.CreateModel(
            name="TransactCampaign",
            fields=[
                (
                    "campaign",
                    models.OneToOneField(
                        related_name="transactcampaign",
                        primary_key=True,
                        serialize=False,
                        to="fan.Campaign",
                    ),
                ),
                (
                    "release_candidate_revision",
                    models.PositiveIntegerField(
                        help_text="\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u043a\u0430\u043d\u0434\u0438\u0434\u0430\u0442\u0430,\u0434\u043b\u044f \u0438\u043d\u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438 \u043a\u044d\u0448\u0430",
                        null=True,
                        blank=True,
                    ),
                ),
                ("experiment_in_progress", models.NullBooleanField()),
                (
                    "experiment_percent",
                    models.PositiveIntegerField(
                        help_text="\u041f\u0440\u043e\u0446\u0435\u043d\u0442 \u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u0440\u0435\u043b\u0438\u0437-\u043a\u0430\u043d\u0434\u0438\u0434\u0430\u0442\u0430",
                        null=True,
                    ),
                ),
                (
                    "experiment_emails",
                    models.TextField(
                        help_text="\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432 \u044d\u043a\u0441\u043f\u0435\u0440\u0438\u043c\u0435\u043d\u0442 \u044d\u0442\u0438 \u0430\u0434\u0440\u0435\u0441\u0430, \u0447\u0435\u0440\u0435\u0437 \u0437\u0430\u043f\u044f\u0442\u0443\u044e",
                        null=True,
                        blank=True,
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u043e\u043d\u043d\u0430\u044f \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0430",
            },
        ),
        migrations.AlterUniqueTogether(
            name="unsubscribelog",
            unique_together=set([("email", "campaign_id")]),
        ),
        migrations.AddField(
            model_name="statslink",
            name="letter",
            field=models.ForeignKey(related_name="+", to="fan.Letter"),
        ),
        migrations.AddField(
            model_name="statsletter",
            name="letter",
            field=models.ForeignKey(related_name="stats_set", to="fan.Letter"),
        ),
        migrations.AddField(
            model_name="statscampaign",
            name="campaign",
            field=models.ForeignKey(related_name="stats_rel", to="fan.Campaign"),
        ),
        migrations.AlterUniqueTogether(
            name="stataction",
            unique_together=set([("letter_id", "action", "email", "link_number")]),
        ),
        migrations.AddField(
            model_name="singleusemaillist",
            name="campaign",
            field=models.OneToOneField(related_name="single_use_maillist", to="fan.Campaign"),
        ),
        migrations.AddField(
            model_name="sendbatch",
            name="campaign",
            field=models.ForeignKey(related_name="+", to="fan.Campaign", db_constraint=False),
        ),
        migrations.AddField(
            model_name="sendbatch",
            name="letter",
            field=models.ForeignKey(related_name="+", to="fan.Letter", db_constraint=False),
        ),
        migrations.AddField(
            model_name="project",
            name="default_service_label",
            field=models.ForeignKey(
                db_constraint=False, blank=True, to="fan.YandexService", null=True
            ),
        ),
        migrations.AddField(
            model_name="processlocks",
            name="campaign",
            field=models.ForeignKey(related_name="+", to="fan.Campaign"),
        ),
        migrations.AddField(
            model_name="monitoringcampaign",
            name="campaign",
            field=models.OneToOneField(related_name="monitoring", to="fan.Campaign"),
        ),
        migrations.AddField(
            model_name="mailwidget",
            name="campaign",
            field=models.ForeignKey(related_name="related_campaign", to="fan.Campaign"),
        ),
        migrations.AddField(
            model_name="maillist",
            name="project",
            field=models.ForeignKey(related_name="list_set", to="fan.Project", null=True),
        ),
        migrations.AddField(
            model_name="letterattachment",
            name="letter",
            field=models.ForeignKey(related_name="attachments", to="fan.Letter"),
        ),
        migrations.AddField(
            model_name="letter",
            name="campaign",
            field=models.ForeignKey(related_name="letters_rel", to="fan.Campaign"),
        ),
        migrations.AddField(
            model_name="eventhook",
            name="project",
            field=models.ForeignKey(related_name="eventhook_set", to="fan.Project", null=True),
        ),
        migrations.AlterIndexTogether(
            name="editoriallog",
            index_together=set([("object_type", "object_id")]),
        ),
        migrations.AddField(
            model_name="domaninunsubscribedemail",
            name="domain",
            field=models.ForeignKey(
                related_name="elements",
                verbose_name="\u0413\u0440\u0443\u043f\u043f\u0430",
                to="fan.UnsubscribeDomain",
            ),
        ),
        migrations.AddField(
            model_name="deliverylog",
            name="campaign",
            field=models.ForeignKey(related_name="+", to="fan.Campaign", db_constraint=False),
        ),
        migrations.AddField(
            model_name="deliverylog",
            name="letter",
            field=models.ForeignKey(related_name="+", to="fan.Letter", db_constraint=False),
        ),
        migrations.AddField(
            model_name="deliveryerrorstats",
            name="campaign",
            field=models.ForeignKey(
                related_name="deliveryerrorstats_set", to="fan.Campaign", db_constraint=False
            ),
        ),
        migrations.AddField(
            model_name="deliveryerrorstats",
            name="letter",
            field=models.ForeignKey(
                related_name="deliveryerrorstats_set",
                db_constraint=False,
                to="fan.Letter",
                null=True,
            ),
        ),
        migrations.AddField(
            model_name="contenthookletter",
            name="letter",
            field=models.ForeignKey(to="fan.Letter"),
        ),
        migrations.AddField(
            model_name="contenthookcampaign",
            name="campaign",
            field=models.ForeignKey(to="fan.Campaign"),
        ),
        migrations.AddField(
            model_name="contenthookcampaign",
            name="contenthook",
            field=models.ForeignKey(to="fan.ContentHook"),
        ),
        migrations.AddField(
            model_name="contenthook",
            name="campaigns",
            field=models.ManyToManyField(
                related_name="contenthook_set",
                through="fan.ContentHookCampaign",
                to="fan.Campaign",
                blank=True,
            ),
        ),
        migrations.AddField(
            model_name="contenthook",
            name="letters",
            field=models.ManyToManyField(
                related_name="contenthook_set",
                through="fan.ContentHookLetter",
                to="fan.Letter",
                blank=True,
            ),
        ),
        migrations.AddField(
            model_name="contenthook",
            name="project",
            field=models.ForeignKey(related_name="contenthook_set", to="fan.Project", null=True),
        ),
        migrations.AddField(
            model_name="campaigndeliveryqueuedata",
            name="campaign",
            field=models.OneToOneField(related_name="queue", to="fan.Campaign"),
        ),
        migrations.AddField(
            model_name="campaignabsettings",
            name="campaign",
            field=models.OneToOneField(related_name="ab_settings_relation", to="fan.Campaign"),
        ),
        migrations.AddField(
            model_name="campaign",
            name="account",
            field=models.ForeignKey(related_name="campaign_set", to="fan.Account"),
        ),
        migrations.AddField(
            model_name="campaign",
            name="clone_of",
            field=models.ForeignKey(
                related_name="clones", db_constraint=False, blank=True, to="fan.Campaign", null=True
            ),
        ),
        migrations.AddField(
            model_name="campaign",
            name="event_hooks",
            field=models.ManyToManyField(to="fan.EventHook", blank=True),
        ),
        migrations.AddField(
            model_name="campaign",
            name="lists",
            field=models.ManyToManyField(to="fan.MailList", blank=True),
        ),
        migrations.AddField(
            model_name="campaign",
            name="project",
            field=models.ForeignKey(related_name="campaigns", to="fan.Project", null=True),
        ),
        migrations.AddField(
            model_name="campaign",
            name="service_label",
            field=models.ForeignKey(blank=True, to="fan.YandexService", null=True),
        ),
        migrations.AddField(
            model_name="campaign",
            name="tags",
            field=models.ManyToManyField(
                related_name="campaigns",
                verbose_name="\u0422\u0435\u0433\u0438",
                to="fan.Tag",
                blank=True,
            ),
        ),
        migrations.AddField(
            model_name="campaign",
            name="unsubscribe_lists",
            field=models.ManyToManyField(
                related_name="campaigns",
                verbose_name="\u0421\u043f\u0438\u0441\u043a\u0438 \u043e\u0442\u043f\u0438\u0441\u043a\u0438",
                to="fan.AccountUnsubscribeList",
                blank=True,
            ),
        ),
        migrations.AddField(
            model_name="campaign",
            name="unsubscribe_redirect",
            field=models.ForeignKey(
                db_constraint=False, blank=True, to="fan.UnsubscribeRedirect", null=True
            ),
        ),
        migrations.AlterUniqueTogether(
            name="bouncelog",
            unique_together=set([("campaign_id", "email", "failure_type")]),
        ),
        migrations.AlterIndexTogether(
            name="bouncelog",
            index_together=set([("created_at", "failure_type")]),
        ),
        migrations.AddField(
            model_name="accountmemberproject",
            name="project",
            field=models.ForeignKey(to="fan.Project"),
        ),
        migrations.AddField(
            model_name="accountmember",
            name="projects",
            field=models.ManyToManyField(
                to="fan.Project", through="fan.AccountMemberProject", blank=True
            ),
        ),
        migrations.AddField(
            model_name="accountmember",
            name="user",
            field=models.ForeignKey(
                related_name="account_set", blank=True, to=settings.AUTH_USER_MODEL, null=True
            ),
        ),
        migrations.AddField(
            model_name="account",
            name="default_service_label",
            field=models.ForeignKey(blank=True, to="fan.YandexService", null=True),
        ),
        migrations.AlterUniqueTogether(
            name="userrole",
            unique_together=set([("user_id", "account", "role")]),
        ),
        migrations.AlterIndexTogether(
            name="unsubscriberedirect",
            index_together=set([("account", "active"), ("account", "slug"), ("project", "active")]),
        ),
        migrations.AddField(
            model_name="transactcampaign",
            name="active_letter",
            field=models.ForeignKey(
                related_name="+",
                blank=True,
                to="fan.Letter",
                help_text="\u0410\u043a\u0442\u0438\u0432\u043d\u043e\u0435 \u043f\u0438\u0441\u044c\u043c\u043e",
                null=True,
            ),
        ),
        migrations.AddField(
            model_name="transactcampaign",
            name="is_revision_for",
            field=models.ForeignKey(related_name="+", to="fan.Campaign", null=True),
        ),
        migrations.AddField(
            model_name="transactcampaign",
            name="release_candidate",
            field=models.ForeignKey(
                related_name="+",
                blank=True,
                to="fan.Letter",
                help_text="\u041f\u0438\u0441\u044c\u043c\u043e-\u043a\u0430\u043d\u0434\u0438\u0434\u0430\u0442",
                null=True,
            ),
        ),
        migrations.AlterUniqueTogether(
            name="tag",
            unique_together=set([("account", "title")]),
        ),
        migrations.AlterUniqueTogether(
            name="statslink",
            unique_together=set([("letter", "link_number", "stat_date")]),
        ),
        migrations.AlterUniqueTogether(
            name="statsletter",
            unique_together=set([("letter", "source", "stat_date")]),
        ),
        migrations.AlterUniqueTogether(
            name="statscampaign",
            unique_together=set([("campaign", "stat_date")]),
        ),
        migrations.AlterUniqueTogether(
            name="project",
            unique_together=set([("account", "slug")]),
        ),
        migrations.AlterUniqueTogether(
            name="processlocks",
            unique_together=set([("campaign", "process_name")]),
        ),
        migrations.AlterUniqueTogether(
            name="option",
            unique_together=set([("content_type", "object_id", "key")]),
        ),
        migrations.AlterUniqueTogether(
            name="letterattachment",
            unique_together=set([("letter", "uri")]),
        ),
        migrations.AlterUniqueTogether(
            name="deliverylog",
            unique_together=set([("campaign", "email")]),
        ),
        migrations.AlterUniqueTogether(
            name="deliveryerrorstats",
            unique_together=set([("stat_date", "campaign", "letter", "status")]),
        ),
        migrations.AlterUniqueTogether(
            name="contenthookletter",
            unique_together=set([("letter", "contenthook")]),
        ),
        migrations.AlterUniqueTogether(
            name="contenthookcampaign",
            unique_together=set([("campaign", "contenthook")]),
        ),
        migrations.AlterUniqueTogether(
            name="campaign",
            unique_together=set([("account", "slug")]),
        ),
        migrations.AlterUniqueTogether(
            name="accountmemberproject",
            unique_together=set([("project", "accountmember")]),
        ),
        migrations.AlterUniqueTogether(
            name="accountmember",
            unique_together=set([("account", "user")]),
        ),
    ]
