import re
from django.db import migrations
from fan.file_models import AvatarsPublisher
from fan.models.letter import Letter


def fix_letter_placeholders(apps, schema_editor):
    for letter in Letter.objects.all():
        remove_opens_counter_placeholder(letter)
        replace_autoloaded_file_placeholder_with_publish_path(letter)


def remove_opens_counter_placeholder(letter):
    regexp = re.compile(r"\{% opens_counter %\}")
    fixed_html_body = re.sub(regexp, "", letter.html_body)
    letter.html_body = fixed_html_body
    letter.save()


def replace_autoloaded_file_placeholder_with_publish_path(letter):
    regexp = re.compile(r'\{% autoloaded_file "([/\.\-\?\w]+)" %\}')

    def repl(matchobj):
        html_uri = matchobj.group(1)
        attachment = letter.attachments.get(uri=html_uri)
        return AvatarsPublisher.get_read_url(attachment.publish_path)

    fixed_html_body = re.sub(regexp, repl, letter.html_body)
    letter.html_body = fixed_html_body
    letter.save()


class Migration(migrations.Migration):
    dependencies = [
        ("fan", "0012_letterattachment_remove_constraint"),
    ]
    operations = [
        migrations.RunPython(fix_letter_placeholders),
    ]
