from zlib import decompress
from django.db import migrations
from fan.lists.csv_maillist import parse_csv_data, get_preview
from fan.models import SingleUseMailList


def add_maillist_data_preview(apps, schema_editor):
    for maillist in SingleUseMailList.objects.all():
        if maillist.data_preview != []:
            continue
        csv_data = decompress(maillist.data).decode()
        csv_maillist = parse_csv_data(csv_data)
        maillist.data_preview = get_preview(csv_maillist)
        maillist.save()


class Migration(migrations.Migration):
    dependencies = [
        ("fan", "0027_alter_field_data_preview_on_singleusemaillist"),
    ]
    operations = [
        migrations.RunPython(add_maillist_data_preview),
    ]
