from django.conf import settings
from django.db import models


def _get_env_short_type():
    t = settings.SENDR_ENV_TYPE or "_"
    if t == "production":
        return ""
    elif t == "testing":
        return "-test"
    elif t == "development":
        return "-dev"
    else:
        return "-" + t


ENV_SUFFIX = _get_env_short_type()


def sane_repr(*attrs):
    if "id" not in attrs and "pk" not in attrs:
        attrs = ("id",) + attrs

    def _repr(self):
        cls = type(self).__name__

        pairs = ("%s=%s" % (a, repr(getattr(self, a, None))) for a in attrs)

        return "<%s at 0x%x: %s>" % (cls, id(self), ", ".join(pairs))

    return _repr


class TimestampsMixin(models.Model):
    class Meta:
        abstract = True

    created_at = models.DateTimeField(auto_now_add=True, editable=False)
    modified_at = models.DateTimeField(auto_now=True, editable=False)


class CreatedByMixin(models.Model):
    class Meta:
        abstract = True

    created_by = models.CharField(max_length=128)

    def set_creator_from_request(self, request):
        if request.user.is_authenticated():
            username = request.user.username
        else:
            username = "<anonymous>"
        self.created_by = username
