from django.db import models


class EditorialLog(models.Model):
    """
    Лог редактирования рассылки
    """

    class Meta:
        index_together = (("object_type", "object_id"),)

    object_type = models.CharField(max_length=128, null=False)  # Например: campaign, account
    object_id = models.CharField(max_length=128, null=False)  # id кампании, аккаунта, etc
    component = models.CharField(max_length=128, null=True)  # Для кампании: body, test, ...
    action = models.CharField(max_length=128, null=True)  # Для кампании: upload_zip, test_sent
    description = models.TextField(null=True)  # Пример: 'Test letter sent to: a@b.ru'
    metadata = models.TextField(null=True)  # Пример: {"test_emails": ["a@b.ru"]}
    user = models.CharField(max_length=128, null=False)  # логин юзера
    datetime = models.DateTimeField(auto_now=True)
    user_ip = models.CharField(max_length=128, null=False)
    user_agent = models.CharField(max_length=255, null=True)
