from django.db import models


class OrganizationSettings(models.Model):
    org_id = models.CharField(max_length=256, unique=True)
    send_emails_limit = models.PositiveIntegerField(null=True)
    trusty = models.NullBooleanField()

    class Meta:
        verbose_name_plural = "Настройки организации"

    def __str__(self):
        return "OrganizationSettings(id={}, org_id={}, send_emails_limit={}, trusty={})".format(
            self.id,
            self.org_id,
            self.send_emails_limit,
            self.trusty,
        )
