from django.db import models
from django.utils.translation import ugettext_lazy as _

from fan.db.fields.separatedvaluesfield import SeparatedValuesField
from fan.utils.slug import create_slug

from .common import CreatedByMixin, TimestampsMixin


class Project(TimestampsMixin, CreatedByMixin, models.Model):
    slug = models.SlugField(unique=False, max_length=192, db_index=False)
    title = models.CharField(max_length=384)
    account = models.ForeignKey("fan.Account", related_name="project_set")

    default_from_name = models.CharField(max_length=384, null=True, blank=True)
    default_from_email = models.CharField(max_length=384, null=True, blank=True)
    default_testing_emails = SeparatedValuesField(max_length=1024, null=True, blank=True)

    deleted = models.BooleanField(default=False)

    class Meta:
        verbose_name_plural = _("Проект")
        unique_together = (("account", "slug"),)

    def __str__(self):
        return "%s:%s" % (self.account, self.title)

    def save(self, *args, **kwargs):
        if not self.slug:
            self.slug = create_slug()
        super().save(*args, **kwargs)
