from django.db import models

from .common import TimestampsMixin, sane_repr


class UserRoleManager(models.Manager):
    pass


class UserRole(TimestampsMixin, models.Model):
    # Роль пользователя в аккаунте

    class ROLES:
        USER = "user"
        MODERATOR = "moderator"
        ASSESSOR_TESTER = "assessor_tester"
        ASSESSOR_MODERATOR = "assessor_moderator"
        CHOICES = ((x, x) for x in (USER, MODERATOR, ASSESSOR_TESTER, ASSESSOR_MODERATOR))

    objects = UserRoleManager()

    account = models.ForeignKey("Account", related_name="roles", db_constraint=False, null=True)
    user_id = models.CharField(max_length=256, db_index=True)
    role = models.CharField(max_length=64, choices=ROLES.CHOICES)
    checked_at = models.DateTimeField(null=True)

    class Meta:
        unique_together = (("user_id", "account", "role"),)

    __repr__ = sane_repr("account", "user_id", "role", "checked_at")

    def __str__(self):
        return "UserRole<id=%s role=%s user_id=%s account=%s>" % (
            self.id,
            self.role,
            self.user_id,
            getattr(self.account, "name", None),
        )
