import random

from django.conf import settings

from fan.db import clickhouse


def _get_client(host, check_connect_timeout=2, check_read_timeout=2):
    """Создаем HTTP клиент до кликхауса, предварительно проверяя его доступность c небольшим чек-таймаутом"""
    client = clickhouse.Client(
        host=host,
        port=settings.CLICKHOUSE_PORT,
        username=settings.CLICKHOUSE_USERNAME,
        password=settings.CLICKHOUSE_PASSWORD,
        timeout=(check_connect_timeout, check_read_timeout),
        secure=getattr(settings, "CLICKHOUSE_SECURE", True),
    )
    client.query("SELECT 1;")
    client.timeout = settings.CLICKHOUSE_TIMEOUT
    return client


def connect_clickhouse(host=None, check_connect_timeout=2, check_read_timeout=2):
    """Пытаемся создать подключение до первого доступного хоста из настроек проекта (либо до указанного явно)

    Не очень красивый костыль на время учений, когда часть хостов кликхауса становится недоступной:
    рандомно сортируем хосты и выбираем первый на котором успешно смогли сделать проверочный запрос `SELECT 1;`.

    Чек-таймаут хоста небольшой, поэтому предусмотрим шанс того, что его просто не хватает -
    если дошли до последнего хоста, то на ошибке таймаута попробуем дефолтный таймаут.
    """
    if host is None:
        hosts = list(settings.CLICKHOUSE_HOSTS)
        random.shuffle(hosts)
    else:
        hosts = [host]

    for i, host in enumerate(hosts, start=1):
        try:
            return _get_client(
                host,
                check_connect_timeout=check_connect_timeout,
                check_read_timeout=check_read_timeout,
            )
        except (clickhouse.TimeoutError, clickhouse.ConnectionError) as exc:
            if i != len(hosts):
                continue

            if isinstance(exc, clickhouse.TimeoutError):
                # может быть чек таймаут просто слишком маленький? на последнем хосте попробуем значения из настроек
                connect_timeout, read_timeout = settings.CLICKHOUSE_TIMEOUT
                return _get_client(
                    host, check_connect_timeout=connect_timeout, check_read_timeout=read_timeout
                )
            else:
                raise
